<?php

function plugin_track_check_update_available() {
    $plugin_slug = 'probance-track/probance-track.php';

    // Forcer le refresh uniquement pour ce plugin
    $transient = get_site_transient('update_plugins');
    if (!isset($transient->checked)) {
        $transient->checked = [];
    }

    // Appel à ton filtre pour recalculer la mise à jour
    $transient = plugin_track_check_for_update($transient);

    set_site_transient('update_plugins', $transient);

    return isset($transient->response[$plugin_slug])
        ? $transient->response[$plugin_slug]
        : false;
}

// Fonction pour refresh le tracker JS
function update_js_file() {

    try{
        $infra=get_option('probance-track_wt-infra');
    
    }catch(Exception $e){

        write_log('[PROBANCE - track] Erreur récupération "probance-track_wt-infra" : '.$e);
    }

    if(isset($infra) && $infra != "")
    {   

        $url = 'https://'.$infra.'/webtrax/public/probance_tracker-min.js'; // Remplace par ton URL
        $plugin_js_path = WP_PLUGIN_DIR . '/probance-track/js/probance_tracker-min.js'; // Chemin du fichier dans le plugin

        $response = wp_remote_get($url);

        if (is_wp_error($response)) {
            echo '<div class="error"><p>Can not retrieve file.</p></div>';
            return;
        }

        $js_content = wp_remote_retrieve_body($response);

        if (!$js_content) {
            echo '<div class="error"><p>File retrieved is empty.</p></div>';
            return;
        }

        // Ajouter la date de mise à jour en commentaire
        $date = date('Y-m-d H:i:s');
        $js_content .= "\n\n// Updated at : " . $date;


        if (!file_put_contents($plugin_js_path, $js_content)) {
            echo '<div class="error"><p>Can not save file.</p></div>';
            return;
        }

        echo '<div class="updated"><p>File '.$save_path.' updated succesfully.</p></div>';
    }
}

?>

<div class="wrap">
    <div id="icon-themes" class="icon32"></div>  
    <h2>Tracking Settings</h2>  
    <!--Display errors if there are some -->
    <?php settings_errors(); 

    $update = plugin_track_check_update_available();
    
    if ($update) {
        echo '<div class="notice notice-warning is-dismissible">';
        echo '<p>🎉 New plugin version available: <strong>' . esc_html($update->new_version) . '</strong></p>';
        echo '<p><a href="' . wp_nonce_url(admin_url('update.php?action=upgrade-plugin&plugin=' . urlencode($update->plugin)), 'upgrade-plugin_' . $update->plugin) . '" class="button button-primary">Update now</a></p>';
        echo '</div>';
    }
   
    
    $plugin_js_path = WP_PLUGIN_DIR . '/probance-track/js/probance_tracker-min.js';
    $last_update = file_exists($plugin_js_path) ? date('Y-m-d H:i:s', filemtime($plugin_js_path)) : 'Never updated';

    try{
        $infra=get_option('probance-track_wt-infra');
        if (isset($infra) && $infra != "")
        {
            ?>
            <div class="wrap">
                <p><strong>Last update :</strong><?php echo esc_html($last_update); ?></p>
                <form method="post" action="">
                    <input type="hidden" name="update_js_action" value="1">
                    <?php submit_button('Update webtrack'); ?>
                </form>
            </div>
            <?php
        }
    }catch(Exception $e){
        
        write_log('[PROBANCE - track] Erreur récupération "probance-track_wt-infra" : '.$e);
    }
    ?>  
    
    <?php

    if (!empty($_POST['update_js_action'])) {
        update_js_file();
    }

    ?>
    <form method="POST" action="options.php">
        <?php 
            //On charge les champs définis
            settings_fields('probance-track_settings');
            do_settings_sections( 'dashboard-admin-track' ); 
        ?>             
        <?php submit_button(); ?>  
    </form> 
</div>