<?php 

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Data;

use ProbanceOptin\Data\Data;
use ProbanceOptin\Data\Translations; 

class NewsletterFields extends Data 
{
        public function __construct()
        {       
                // Default values
                $mainTitleHtmlTag="h2";
                $subTitleHtmlTag="h4";
                $defaultFNameErrMsgCss='color:red; font-size: 12px;';
                $defaultLNameErrMsgCss=$defaultFNameErrMsgCss;
                $defaultEmailErrMsgCss=$defaultFNameErrMsgCss;
                
                // Create data array
                $data= array (                        
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lbtitle',
                                'name'      => 'probance-optin_banner-lbtitle',
                                'properties' => array ( 'edit-h-style'  => array('label' => 'Title CSS', 'default_value' => ''),
                                                        'edit-html-tag' => array('label' => 'HTML tag', 'default_value' => "$mainTitleHtmlTag"),  
                                                        'edit-class' => array('label' => 'Edit Class', 'default_value' => '')),
                                'properties-label' => 'Main Title',
                                'size'      => '60',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lbsubtitle',
                                'name'      => 'probance-optin_banner-lbsubtitle',
                                'properties' => array ( 'edit-h-style'  => array('label' => 'Title CSS', 'default_value' => ''),
                                                        'edit-html-tag' => array('label' => 'HTML tag', 'default_value' => "$subTitleHtmlTag"),  
                                                        'edit-class' => array('label' => 'Edit Class', 'default_value' => '')),
                                'properties-label' => 'Subtitle',
                                'size'      => '60',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbnames',
                                'name'      => 'probance-optin_banner-cbnames',
                                'size'      => '',
                                'properties-label' => 'With First Name & Last Name',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbnames-required',
                                'name'      => 'probance-optin_banner-cbnames-required',
                                'size'      => '',
                                'properties-label' => 'Is required',
                                'required' => '',       
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbtwocols',
                                'name'      => 'probance-optin_banner-cbtwocols',
                                'size'      => '',
                                'properties-label' => 'Display Names same row',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lbfname',
                                'name'      => 'probance-optin_banner-lbfname',
                                'properties' => array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'First Name',
                                'size'      => '',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-fname-error-msg',
                                'name'      => 'probance-optin_banner-fname-error-msg',
                                'size'      => '',
                                'properties' => array ('edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultFNameErrMsgCss)),
                                'properties-label'=> 'Fisrt Name Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lblname',
                                'name'      => 'probance-optin_banner-lblname',
                                'size'      => '',
                                'properties' =>  array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'Last Name',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lname-error-msg',
                                'name'      => 'probance-optin_banner-lname-error-msg',
                                'size'      => '',
                                'properties' => array ('edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultLNameErrMsgCss)),
                                'properties-label' => 'Last Name Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbbirthday',
                                'name'      => 'probance-optin_banner-cbbirthday',
                                'size'      => '',
                                'properties-label' => 'Add birthday field',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbbirthday-required',
                                'name'      => 'probance-optin_banner-cbbirthday-required',
                                'size'      => '',
                                'properties-label' => 'Is required',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-birthday',
                                'name'      => 'probance-optin_banner-birthday',
                                'size'      => '',
                                'properties' =>  array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'Birthday',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-birthday-error-msg',
                                'name'      => 'probance-optin_banner-birthday-error-msg',
                                'size'      => '',
                                'properties' => array ('edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultFNameErrMsgCss)),
                                'properties-label' => 'Birthday Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbgender',
                                'name'      => 'probance-optin_banner-cbgender',
                                'size'      => '',
                                'properties-label' => 'Add gender field',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbgender-required',
                                'name'      => 'probance-optin_banner-cbgender-required',
                                'size'      => '',
                                'properties-label' => 'Is required',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'select',
                                'id'    => 'probance-optin_banner-gender',
                                'name'      => 'probance-optin_banner-gender',
                                'size'      => '',
                                'properties' =>  array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'Gender',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-gender-error-msg',
                                'name'      => 'probance-optin_banner-gender-error-msg',
                                'size'      => '',
                                'properties' => array ('edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultFNameErrMsgCss)),
                                'properties-label' => 'Gender Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cblanguage',
                                'name'      => 'probance-optin_banner-cblanguage',
                                'size'      => '',
                                'properties-label' => 'Add language field',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cblanguage-required',
                                'name'      => 'probance-optin_banner-cblanguage-required',
                                'size'      => '',
                                'properties-label' => 'Is required',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-language',
                                'name'      => 'probance-optin_banner-language',
                                'size'      => '',
                                'properties' =>  array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'Preferred Language',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-language-error-msg',
                                'name'      => 'probance-optin_banner-language-error-msg',
                                'size'      => '',
                                'properties' => array ('edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultFNameErrMsgCss)),
                                'properties-label' => 'Language Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lbemail',
                                'name'      => 'probance-optin_banner-lbemail',
                                'properties' =>  array ('edit-input-style' => array ( 'label' => 'Input CSS', 'default_value' => ''),
                                                        'edit-input-hover-style' => array( 'label' => 'Input Hover CSS', 'default_value' => ''),
                                                        'edit-input-focus-style' => array( 'label' => 'Input Focus CSS', 'default_value' => ''),
                                                        'edit-label-style' => array( 'label' => 'Label CSS', 'default_value' => ''), 
                                                        'edit-label-class' => array( 'label' => 'Label Class', 'default_value' => ''),  
                                                        'edit-input-class' => array( 'label' => 'Input Class', 'default_value' => '')),
                                'properties-label' => 'Email',
                                'size'      => '',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-email-error-msg',
                                'name'      => 'probance-optin_banner-email-error-msg',
                                'size'      => '',
                                'properties' =>array (  'edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultEmailErrMsgCss)),
                                'properties-label'      => 'Email Error Msg',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        // array (
                        //         'type'      => 'input',
                        //         'subtype'   => 'text',
                        //         'id'    => 'probance-optin_banner-email-empty-msg',
                        //         'name'      => 'probance-optin_banner-email-empty-msg',
                        //         'size'      => '',
                        //         'properties' =>array (  'edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => $defaultEmailErrMsgCss)),
                        //         'properties-label'      => 'Email Empty Msg',
                        //         'required' => 'required="required"',
                        //         'value_type'=>'normal',
                        //         'wp_data' => 'option',
                        //         'default_value' => '',
                        //         'to_translate' => true,
                        //         'optional' => false
                        // ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'        => 'probance-optin_banner-lbbtn',
                                'name'      => 'probance-optin_banner-lbbtn',
                                'size'      => '',
                                'properties' => array ( 'edit-css-style' => array( 'label' => 'Button CSS', 'default_value' => ''), 
                                                        'edit-hover-style' => array( 'label' => 'Hover CSS', 'default_value' => ''), 
                                                        'edit-focus-style' => array( 'label' => 'Focus CSS', 'default_value' => ''),  
                                                        'edit-class' => array( 'label' => 'Edit Class', 'default_value' => '')),
                                'properties-label' => 'Button',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-conf-message',
                                'name'      => 'probance-optin_banner-conf-message',
                                'size'      => '',
                                'properties' => array ( 'edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => '')),
                                'properties-label' => 'Confirmation Message',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-conf-error-message',
                                'name'      => 'probance-optin_banner-conf-error-message',
                                'size'      => '',
                                'properties' => array ( 'edit-css-style' => array( 'label' => 'Style CSS', 'default_value' => '')),
                                'properties-label' => 'Error Message',
                                'required' => 'required="required"',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-cbrecaptcha',
                                'name'      => 'probance-optin_banner-cbrecaptcha',
                                'size'      => '',
                                'properties-label'      => 'Add reCAPTCHA v3',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '0',
                                'to_translate' => true
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-recaptchasitekey',
                                'name'      => 'probance-optin_banner-recaptchasitekey',
                                'size'      => '60',
                                'properties-label'      => 'Site Key',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-recaptchaprivatekey',
                                'name'      => 'probance-optin_banner-recaptchaprivatekey',
                                'size'      => '60',
                                'properties-label'      => 'Secret Key',
                                'required' => '',
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false
                        ),
                        array (
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-lbshortcode',
                                'name'      => 'probance-optin_banner-lbshortcode',
                                'size'      => '',
                                'properties-label' => 'Shortcode',
                                'required' => '',
                                'disabled' => true,
                                'value_type'=>'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => false,
                                'optional' => false
                        )

                );

                // Set default value using translations/_default.json file
                $data=Translations::setDefaultValues($data);

                parent::__construct($data);
        }

        public function getSectionInfo()
        {
                return array("id" => "probance-optin_section-wbanner", "title" => "Newsletter");
        }
}

?>