<?php
    function plugin_optin_check_update_available() {
        $plugin_slug = 'probance-optin/probance-optin.php';

        // Forcer le refresh uniquement pour ce plugin
        $transient = get_site_transient('update_plugins');
        if (!isset($transient->checked)) {
            $transient->checked = [];
        }

        // Appel à ton filtre pour recalculer la mise à jour
        $transient = plugin_optin_check_for_update($transient);

        set_site_transient('update_plugins', $transient);

        return isset($transient->response[$plugin_slug])
            ? $transient->response[$plugin_slug]
            : false;
    }
?>

<div class="wrap">
    <div id="icon-themes" class="icon32"></div>
    <h2>Optin Settings</h2>
    <!--Display errors if there are some -->
    <?php settings_errors(); ?>    

    <?php
        $update = plugin_optin_check_update_available();
        
        if ($update) {
            echo '<div class="notice notice-warning is-dismissible">';
            echo '<p>🎉 New plugin version available: <strong>' . esc_html($update->new_version) . '</strong></p>';
            echo '<p><a href="' . wp_nonce_url(admin_url('update.php?action=upgrade-plugin&plugin=' . urlencode($update->plugin)), 'upgrade-plugin_' . $update->plugin) . '" class="button button-primary">Update now</a></p>';
            echo '</div>';
        }
    ?>

    <form method="POST" action="options.php">
        <?php
        //On charge les champs définis
        settings_fields('probance-optin_optin-settings');
        do_settings_sections('probance');
        ?>
        <?php submit_button(); ?>
    </form>
</div>