<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Pmail;

use ProbanceOptin\Data\Translations;
use ProbanceOptin\Common\Utils;
use ProbanceOptin\Common\PmailAPI;

class Pmail
{
    public function register()
    {
        add_action('user_register', array($this, 'send_new_account_campaign'));
    }

    /**
     * New registration function
     */
    function send_new_account_campaign($user_id)
    {

        Utils::write_log('[PROBANCE - PMAIL] New account creation detected ');

        // Do pmail call
        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - PMAIL] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
            $debug = 0;
        }

        $infra = get_option('probance-optin_api-infra');

        $user_locale = Utils::get_user_preferred_language();

        Utils::write_log('[PROBANCE - PMAIL] user_locale : ' . $user_locale);

        $pmail_settings = Translations::getTranslatedFields('pmail', $user_locale);

        Utils::write_log('[PROBANCE - PMAIL] object campaign : ' . json_encode($pmail_settings, true));
        Utils::write_log('[PROBANCE - PMAIL] POST data       : ' . json_encode($_POST, true));

        if (isset($pmail_settings)) {
            $pmail_token = $pmail_settings['probance-optin_banner-pmail-token'];
            $pmail_campaign = $pmail_settings['probance-optin_banner-pmail-newaccount'];
            $pmail_activated = (isset($pmail_settings['probance-optin_banner-pmail-newaccount-cb']) && $pmail_settings['probance-optin_banner-pmail-newaccount-cb'] == '1');

            if (isset($pmail_token) && $pmail_token != '') {
                if ($pmail_activated) {
                    if (isset($pmail_campaign) && $pmail_campaign != '') {
                        // Payload of PMAIL API call
                        $pmail_payload = array(
                            "campaign_external_id" => $pmail_campaign,
                            "custom_fields" => array("name1", "name2"),
                            "recipients" => [
                                array(
                                    "contact_id" => $_POST['email'],
                                    "email" => $_POST['email'],
                                    "custom_values" => array(
                                        (isset($_POST['account_first_name']) ? $_POST['account_first_name'] : ''),
                                        (isset($_POST['account_last_name']) ? $_POST['account_last_name'] : '')
                                    )
                                )
                            ]
                        );

                        (new PmailAPI())->send_campaign($pmail_payload);
                    } else {
                        Utils::write_log('[PROBANCE - PMAIL] New account campaign ID is missing.');
                    }
                } else {
                    Utils::write_log('[PROBANCE - PMAIL] New account campaign is not enabled.');
                }
            } else {
                Utils::write_log('[PROBANCE - PMAIL] Pmail token is missing.');
            }
        } else {
            Utils::write_log('[PROBANCE - PMAIL] pmail settings not found');
        }
    }
}
