jQuery(document).ready(function ($) {
    ///////////////////////////////////////////////////////
    // VARIABLES
    ///////////////////////////////////////////////////////
    /*
     */
    popups = $("div#probance_popup_overlay");
    coockie = "probance_popup";

    console.log(popups);

    ///////////////////////////////////////////////////////
    // COMMON FUNCTIONS
    ///////////////////////////////////////////////////////

    // Close pop-up : on click button
    $("#probance_popup_overlay .close-btn").click(function (e) {
        var overlay = e.target.parentNode.parentNode; // Parent node of close button is the span, and its parent is the popup div
        overlay.style.display = "none";
        $("body").removeClass("probance-no-scroll");
        $("html").removeClass("probance-no-scroll");
    });

    // Close pop-up : on click overlay
    // $("#probance_popup_overlay").click(function(e) {
    //     var popup = e.target; // Parent node of close button is the span, and its parent is the popup div
    //     popup.style.display = 'none';
    // });

    ///////////////////////////////////////////////////////
    // Cookie de la popup
    ///////////////////////////////////////////////////////
    // Vérifiez si le cookie existe et sa date d'expiration
    function checkCookie(popup_id) {
        var cookie = getCookie(`${coockie}_${popup_id}`);
        if (cookie) {
            var currentDate = new Date();
            var expirationDate = new Date(cookie);
            expirationDate.setDate(expirationDate.getDate() + 1); // Ajoutez un jour à la date du dernier affichage
            if (currentDate < expirationDate) {
                return false; // Le cookie existe et n'a pas encore expiré
            }
        }
        return true; // Le cookie n'existe pas ou a expiré
    }

    // Fonction pour récupérer la valeur d'un cookie
    function getCookie(name) {
        var value = "; " + document.cookie;
        var parts = value.split("; " + name + "=");
        if (parts.length === 2) return parts.pop().split(";").shift();
    }

    // Fonction pour définir un cookie avec une date d'expiration
    function setCookie(name, value, time_value, time_unit) {
        var expires = "";

        if (time_value === 0) {
            // ancien fonctionnement
            // expires = "; expires=" + new Date(new Date().getTime() + 5 * 60 * 1000).toGMTString();
            //  On veut pouvoir ne pas créer de Cooie sur un mode "manual" donc si 0 on ne créé pas de cookie
            return;
        } else if (time_unit == "hours") {
            expires = "; expires=" + new Date(new Date().getTime() + time_value * 60 * 60 * 1000).toGMTString();
        } else if (time_unit == "days") {
            expires = "; expires=" + new Date(new Date().getTime() + time_value * 24 * 60 * 60 * 1000).toGMTString();
        } else if (time_unit == "minutes") {
            expires = "; expires=" + new Date(new Date().getTime() + time_value * 60 * 1000).toGMTString();
        }

        console.log("EXP DATE  : " + expires);

        document.cookie = name + "=" + (value || "") + expires + "; path=/";
    }

    // Vérifier si l'URL est celle de la page de prévisualisation
    if (window.location.href.indexOf("preview=true") !== -1) {
        // Ajouter votre comportement supplémentaire ici
        // console.log('Vous êtes sur la page de prévisualisation.');

        // console.log(popupsList.data);

        // Obtenir la chaîne de requête de l'URL
        var queryString = window.location.search;

        // Créer un objet URLSearchParams à partir de la chaîne de requête
        var searchParams = new URLSearchParams(queryString);

        // Obtenir la valeur d'un paramètre spécifique
        var popupID = searchParams.get("preview_id");

        $(`#probance_popup_overlay[data-popupid=${popupID}]`).show();

        return;
    }

    ///////////////////////////////////////////////////////
    // Affichage des popups
    ///////////////////////////////////////////////////////
    // Sélectionnez toutes les popups sur la page
    // Parcourez chaque popup
    popups.each(function () {
        console.log($(this));

        // Récupérez les attributs data
        var popupId = $(this).data("popupid");
        var delay = $(this).data("delay");
        var scrollTriggerPercentage = $(this).data("scroll-percentage");
        var trigger = $(this).data("trigger") || 50;
        var time_value = $(this).data("time-value") || 0;
        var time_unit = $(this).data("time-unit") || "minutes";

        console.log("popupId " + popupId);
        console.log("delay " + delay);
        console.log("scrollTriggerPercentage " + scrollTriggerPercentage);
        console.log("trigger " + trigger);
        console.log("time value " + time_value);
        console.log("time unit " + time_unit);

        // Vérifiez si la pop-up doit être affichée via son cookie
        if (checkCookie(popupId)) {
            // Affichez la pop-up

            // Enregistrez la date actuelle comme la dernière fois que la pop-up a été affichée
            setCookie(`${coockie}_${popupId}`, new Date(), time_value, time_unit); // Cookie expire dans 1 jour
        } else {
            // Le cookie existe
            console.log("Cookies already exists !");
            return 0;
        }

        console.log("Display popup " + popupId);

        // Vérifier le type de trigger défini
        switch (trigger) {
            case "manual":
                console.log("You are in manual mode !");
                break;
            case "delay":
                if (delay !== undefined && !isNaN(delay)) {
                    // Affichez la popup après le délai spécifié
                    setTimeout(
                        function () {
                            $(this).show(); // Affichage de la popup (vous pouvez adapter selon votre structure HTML)
                            $("body").addClass("probance-no-scroll");
                            $("html").addClass("probance-no-scroll");
                        }.bind(this),
                        delay * 1000
                    ); // Utilisez bind pour lier correctement la référence 'this'
                }
                break;

            case "scroll":
                already_displayed = false;
                // Ajoutez un écouteur de scroll pour afficher la popup lorsque l'utilisateur fait défiler la page
                $(window).scroll(
                    function () {
                        if (already_displayed) return;
                        // Vérifiez si l'utilisateur a fait défiler suffisamment pour afficher la popup
                        // Vous pouvez ajuster la logique selon votre besoin
                        var scrollTop = $(window).scrollTop();
                        var scrollPercentage = (scrollTop / ($(document).height() - $(window).height())) * 100;
                        if (scrollPercentage >= scrollTriggerPercentage) {
                            $(this).show(); // Affichage de la popup (vous pouvez adapter selon votre structure HTML)
                            $("body").addClass("probance-no-scroll");
                            $("html").addClass("probance-no-scroll");
                            already_displayed = true;
                        }
                    }.bind(this)
                ); // Utilisez bind pour lier correctement la référence 'this'
                break;

            default:
                console.log("Pop-up trigger undefined. ");
                break;
        }
    });
});
