jQuery(document).ready(function ($) {
    ///////////////////////////////////////////////////////
    // VARIABLES
    ///////////////////////////////////////////////////////
    /*
     * Variables GLOBALES récupérées depuis probance-optin.php
     */
    var debug = probance_newsletter.debug;
    var path = probance_newsletter.ajaxurl;
    var names = probance_newsletter.cbnames;
    var sitekey = probance_newsletter.rc_sitekey;
    var recaptcha = probance_newsletter.cb_recaptcha;

    ///////////////////////////////////////////////////////
    // FUNCTIONS
    ///////////////////////////////////////////////////////
    // Function to validate email field
    function validateEmail(email) {
        const re =
            /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(email);
    }

    // Function to validate email field
    function validateDate(date) {
        const re = /^(\d{4})-(\d{2})-(\d{2})$/;
        return re.test(date);
    }

    // Function to validate name fields
    function validateName(name) {
        const re = /^[a-zA-Z-àèìòùÀÈÌÒÙáéíóúýÁÉÍÓÚÝâêîôûÂÊÎÔÛãñõÃÑÕäëïöüÿÄËÏÖÜŸçÇßØøÅåÆæœ'. ]+$/;

        if (name == "") return true;

        return re.test(name);
    }

    function validateLanguage(lang) {
        const re = /^[a-zA-Z]{2}$/;

        if (lang == "") return true;

        return re.test(lang);
    }

    function convertFrenchTextDate(input) {
        const mois = {
            janvier: '01', février: '02', fevrier: '02', mars: '03',
            avril: '04', mai: '05', juin: '06', juillet: '07',
            août: '08', aout: '08', septembre: '09', octobre: '10',
            novembre: '11', décembre: '12', decembre: '12'
        };

        const regex = /^(\d{1,2})\s+([a-zéûôàèêîç]+)\s+(\d{4})$/i;
        const match = input.trim().toLowerCase().match(regex);

        if (match) {
            const day = match[1].padStart(2, '0');
            const monthText = match[2];
            const year = match[3];

            const month = mois[monthText];
            if (month) {
                return `${day}-${month}-${year}`;
            }
        }
        return null;
    }


    // Function to clear error messages
    function cleanErrorMsg(el) {
        // Hide error messages
        $(`form#${el.id} span[data-type="message"]`).addClass("hidden");
        $(`form#${el.id} p[data-type="message"]`).addClass("hidden");

        // Remove red border on inputs fields
        $(`form#${el.id} input.error`).removeClass("error");

        // checkbox error
        $(`form#${el.id} div#probance_optin_cb_wrapper span`).removeClass("error");
    }

    // Function to clear fileds values
    function cleanFormFields(el) {
        id = `${el.id}`.split("_").pop();
        $(`form#${el.id} input#probance_newsletter_email_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_fname_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_lname_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_birthday_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_custom1_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_custom2_${id}`).val("");
        $(`form#${el.id} input#probance_newsletter_custom3_${id}`).val("");
        $(`form#${el.id} input#probance_optin_cb_nl_${id}`).prop("checked", false);
    }

    // Function to POST form to the server
    function sendToServerAction(el, gtoken = "") {
        cleanErrorMsg(el);

        /*
         * Retrieve form data
         */
        var form_data = el;
        var form_id = el.id;
        var id = `${el.id}`.split("_").pop();

        if (debug == 1) console.log(el);
        if (debug == 1) console.log(el.id);

        // Valeur par défaut des variables
        var gtoken = gtoken;
        var gender =
            $(`form#${form_id} #probance_newsletter_gender_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_gender_${id}`).val();
        var fname =
            $(`form#${form_id} #probance_newsletter_fname_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_fname_${id}`).val();
        var lname =
            $(`form#${form_id} #probance_newsletter_lname_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_lname_${id}`).val();
        var birthday =
            $(`form#${form_id} #probance_newsletter_birthday_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_birthday_${id}`).val();
        var language =
            $(`form#${form_id} #probance_newsletter_language_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_language_${id}`).val();
        var custom1 =
            $(`form#${form_id} #probance_newsletter_custom1_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_custom1_${id}`).val();
        var custom2 =
            $(`form#${form_id} #probance_newsletter_custom2_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_custom2_${id}`).val();
        var custom3 =
            $(`form#${form_id} #probance_newsletter_custom3_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_custom3_${id}`).val();
        var email =
            $(`form#${form_id} #probance_newsletter_email_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_email_${id}`).val();
        var hp =
            $(`form#${form_id} #probance_newsletter_info_fk_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #probance_newsletter_info_fk_${id}`).val();
        var required_fields = $(`form#${form_id} input[required="true"]`);
        var campaign_id = $(`form#${form_id}`)[0].attributes["data-probance-campaign-id"].nodeValue;
        var custom_tag =
            $(`form#${form_id} #custom_tag_${id}`).val() == undefined
                ? null
                : $(`form#${form_id} #custom_tag_${id}`).val();

        // Loader
        $(`form#${form_id} div.loader-overlay`).addClass("visible");

        if (debug == 1) console.log(required_fields);
        // Mode DEBUG
        if (debug == 1) {
            console.log("URL for AJAX : " + path);
            console.log("gtoken (reCAPTCHA): " + gtoken);
            console.log("First name : " + fname);
            console.log("Last name : " + lname);
            console.log("Email address : " + email);
            console.log("Gender : " + gender);
            console.log("Birthday date : " + birthday);
            console.log("Preferred language : " + language);
            console.log("Campagne ID : " + campaign_id);
            console.log("Custom tag : " + custom_tag);
            console.log("Custom 1 : " + custom1);
            console.log("Custom 2 : " + custom2);
            console.log("Custom 3 : " + custom3);
        }

        /*
         * Field verification
         */
        $fields_are_valid = true;

        if (birthday && !validateDate(birthday)) {
            
            const corrected = convertFrenchTextDate(val);

            if (corrected) {
                birthday = corrected; // Corrige directement la valeur dans le champ
            } else {

                $fields_are_valid = false;
                // Display error msg
                $(`form#${form_id} span.probance_msg_wrong_birthday`).removeClass("hidden");
                $(`form#${form_id} input#probance_newsletter_birthday_${id}`).addClass("error");

                // Mode DEBUG
                if (debug == 1) console.log(`[NEWSLETTER FORM] birthday incorrecte`);
            }
        
        }

        if (fname && !validateName(fname)) {
            $fields_are_valid = false;

            // Display error msg
            $(`form#${form_id} span.probance_msg_wrong_fname`).removeClass("hidden");
            $(`form#${form_id} input#probance_newsletter_fname_${id}`).addClass("error");

            // Mode DEBUG
            if (debug == 1) console.log(`[NEWSLETTER FORM] fname incorrecte`);
        }

        if (lname && !validateName(lname)) {
            $fields_are_valid = false;

            // Display error msg
            $(`form#${form_id} span.probance_msg_wrong_lname`).removeClass("hidden");
            $(`form#${form_id} input#probance_newsletter_lname_${id}`).addClass("error");

            // Mode DEBUG
            if (debug == 1) console.log(`[NEWSLETTER FORM] lname incorrecte`);
        }

        if (gender && !validateName(gender)) {
            $fields_are_valid = false;

            // Display error msg
            $(`form#${form_id} span.probance_msg_wrong_gender`).removeClass("hidden");
            $(`form#${form_id} input#probance_newsletter_gender_${id}`).addClass("error");

            // Mode DEBUG
            if (debug == 1) console.log(`[NEWSLETTER FORM] gender incorrecte`);
        }

        if (language && !validateLanguage(language)) {
            $fields_are_valid = false;

            // Display error msg
            $(`form#${form_id} span.probance_msg_wrong_language`).removeClass("hidden");
            $(`form#${form_id} input#probance_newsletter_language_${id}`).addClass("error");

            // Mode DEBUG
            if (debug == 1) console.log(`[NEWSLETTER FORM] language incorrecte`);
        }

        if (!validateEmail(email)) {
            $fields_are_valid = false;

            // If email empty we init another error msg
            if (email == "") {
                $(`form#${form_id} span.probance_msg_empty_email`).removeClass("hidden");
            } else {
                // Display error msg
                $(`form#${form_id} span.probance_msg_wrong_email`).removeClass("hidden");
                $(`form#${form_id} input#probance_newsletter_email_${id}`).addClass("error");
            }

            // Mode DEBUG
            if (debug == 1) console.log("[NEWSLETTER FORM] L'adresse email est incorrecte");
        }

        if (
            $(`form#${form_id} input#probance_optin_cb_nl_${id}`).is("*") &&
            !$(`form#${form_id} input#probance_optin_cb_nl_${id}`).is(":checked")
        ) {
            $fields_are_valid = false;

            $(`form#${form_id} div#probance_optin_cb_wrapper span`).addClass("error");
            // Mode DEBUG
            if (debug == 1) console.log("[NEWSLETTER FORM] Vous devez accepter de recevoir des offres commerciales.");
        }

        // If there is an error we exit the function
        if (!$fields_are_valid) {
            // Loader
            $(`form#${form_id} div.loader-overlay`).removeClass("visible");

            return false;
        }

        /*
         * POST REQUEST
         */
        // Mode DEBUG
        if (debug == 1) console.log("[NEWSLETTER FORM] Envoi du formulaire vers le serveur.");

        // Check the honey pot field. If not empty, a robot is detected. Else we can send POST request.
        if (hp != "" && hp != null) {
            // Mode DEBUG
            if (debug == 1) console.log("Suspicious action detected by Honey Pot.");

            // Fake news
            $(`form#${form_id} .probance_message_submit`).removeClass("hidden");

            // Clear fields
            cleanFormFields(el);

            // Loader
            $(`form#${form_id} div.loader-overlay`).removeClass("visible");

            return false;
        } else {
            /*
             * POST REQUEST -> load_newsletter_form.
             * SERVER SIDE handle by the probance_submit_newletter_form function into probance-optin.php
             */
            $.ajax({
                url: path,
                type: "POST",
                data: {
                    action: "load_newsletter_form",
                    "g-token": gtoken,
                    gender: gender,
                    fname: fname,
                    lname: lname,
                    birthday: birthday,
                    language: language,
                    email: email,
                    custom1: custom1,
                    custom2: custom2,
                    custom3: custom3,
                    campaign_id: campaign_id,
                    custom_tag: custom_tag,
                },
                success: function (data) {
                    // Loader
                    $(`form#${form_id} div.loader-overlay`).removeClass("visible");

                    if (debug == 1) console.log("Data retrieved from PHP  : " + JSON.stringify(data));

                    if (data["success"]) {
                        $(`form#${form_id} .probance_message_submit`).removeClass("hidden");

                        cleanFormFields(el);

                        return true;
                    } else {
                        // Loader
                        $(`form#${form_id} div.loader-overlay`).removeClass("visible");

                        $(`form#${form_id} .probance_message_submit_faillure`).removeClass("hidden");

                        return false;
                    }
                },
            });
        }
    }

    $('form[id^="probance_form_"]').on("submit", function (e) {
        e.preventDefault();

        if (debug == 1) console.log(e);

        if (recaptcha == 1) {
            // Mode DEBUG
            if (debug == 1) console.log("reCAPTCHA verification...");

            grecaptcha.ready(function () {
                if (debug == 1) console.log("sitekey : " + sitekey);

                try {
                    grecaptcha.execute(sitekey, { action: "submit" }).then(function (token) {
                        // Mode DEBUG
                        if (debug == 1) console.log("g-token : " + token);

                        $(`form#${e.target.id} #g-token`).val(token);

                        if (debug == 1)
                            console.log("reCAPTCHA security. Form is send to the server with the secure method.");

                        sendToServerAction(e.target, token);
                    });
                } catch (error) {
                    // console.error(error);
                    console.error(
                        "You seem to have a problem with reCaptcha v3. Please check Google Recaptch API v3 credentials. See details : " +
                            error
                    );
                    $(`form#${e.target.id} .probance_message_submit_faillure`).removeClass("hidden");

                    return false;
                }
            });
        } else {
            if (debug == 1) console.log("No reCAPTCHA security. Form is send to the server with the standard method.");
            sendToServerAction(e.target);
        }
    });

    $("p.icon_close").on("click", function (e) {
        // console.log(e.target.parentNode);
        $(`div.${e.target.parentNode.className}`).addClass("hidden");
    });
});
