jQuery(document).ready(function ($) {
    ///////////////////////////////////////////////////////
    // VARIABLES
    ///////////////////////////////////////////////////////
    /*
     * path : used for ajax calls
     * names_fields_to_handle : used to handle show or hide optionnals fields
     * recaptcha_fields_to_handle : used to handle show or hide optionnals fields
     */
    var debug = admin.debug;
    var path = admin.ajaxurl;
    var names_fields_to_handle = [
        "#probance-optin_banner-lbfname",
        "#probance-optin_banner-lblname",
        "#probance-optin_banner-cbtwocols",
        "#probance-optin_banner-lname-error-msg",
        "#probance-optin_banner-fname-error-msg",
    ];
    var recaptcha_fields_to_handle = [
        "#probance-optin_banner-recaptchasitekey",
        "#probance-optin_banner-recaptchaprivatekey",
    ];
    var birthday_fields_to_handle = [
        "#probance-optin_banner-cbbirthday-required",
        "#probance-optin_banner-birthday",
        "#probance-optin_banner-birthday-error-msg",
    ];
    var gender_fields_to_handle = [
        "#probance-optin_banner-cbgender-required",
        "#probance-optin_banner-gender",
        "#probance-optin_banner-gender-error-msg",
    ];
    var language_fields_to_handle = [
        "#probance-optin_banner-cblanguage-required",
        "#probance-optin_banner-language",
        "#probance-optin_banner-language-error-msg",
    ];
    var custom1_fields_to_handle = [
        "#probance-optin_banner-cbcustom1-required",
        "#probance-optin_banner-custom1",
        "#probance-optin_banner-custom1-error-msg",
    ];
    var custom2_fields_to_handle = [
        "#probance-optin_banner-cbcustom2-required",
        "#probance-optin_banner-custom2",
        "#probance-optin_banner-custom2-error-msg",
    ];
    var custom3_fields_to_handle = [
        "#probance-optin_banner-cbcustom3-required",
        "#probance-optin_banner-custom3",
        "#probance-optin_banner-custom3-error-msg",
    ];
    var activate_fields_to_handle = [
        "#probance-optin_banner-pmail-newaccount-cb",
        "#probance-optin_banner-pmail-newsubscriber-1-cb",
        "#probance-optin_banner-pmail-newsubscriber-2-cb",
        "#probance-optin_banner-pmail-newsubscriber-3-cb",
    ];

    ///////////////////////////////////////////////////////
    // FUNCTIONS
    ///////////////////////////////////////////////////////

    Object.defineProperty(String.prototype, "capitalize", {
        value: function () {
            return this.charAt(0).toUpperCase() + this.slice(1);
        },
        enumerable: false,
    });

    /*
     * Function to show activate fileds
     */
    function show_activate_fields() {
        activate_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).attr("required", true);
        });

        return;
    }

    /*
     * Function to hide activate fileds
     */
    function hide_activate_fields() {
        activate_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).attr("required", false);
        });

        return;
    }

    /*
     * Function to show birthday fileds
     */
    function show_birthday_fields() {
        birthday_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).attr("required", true);
        });

        return;
    }

    /*
     * Function to show gender fileds
     */
    function show_gender_fields() {
        gender_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).attr("required", true);
        });

        return;
    }

    /*
     * Function to show language fileds
     */
    function show_language_fields() {
        language_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).attr("required", true);
        });

        return;
    }

    /*
     * Function to show names fileds
     */
    function show_names_fields() {
        names_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).attr("required", true);
        });

        return;
    }

    /*
     * Function to show birthday fileds
     */
    function hide_birthday_fields() {
        birthday_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to show gender fileds
     */
    function hide_gender_fields() {
        gender_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to show language fileds
     */
    function hide_language_fields() {
        language_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to show names fileds
     */
    function show_names_fields() {
        names_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).prop("required", true);
        });

        return;
    }

    /*
     * Function to show recaptcha fileds
     */
    function show_recaptcha_fields() {
        recaptcha_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).prop("required", true);
        });

        return;
    }

    /*
     * Function to hide names fileds
     */
    function hide_names_fields() {
        names_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to hide names fileds
     */
    function hide_custom1_fields() {
        custom1_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    function hide_custom3_fields() {
        custom3_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    function hide_custom2_fields() {
        custom2_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to show custom fileds
     */
    function show_custom1_fields() {
        custom1_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).prop("required", true);
        });

        return;
    }

    function show_custom2_fields() {
        custom2_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).prop("required", true);
        });

        return;
    }

    function show_custom3_fields() {
        custom3_fields_to_handle.forEach((field) => {
            $(field).parents("tr").show();
            $(field).attr("type") == "text" && $(field).prop("required", true);
        });

        return;
    }

    /*
     * Function to hide recaptcha fileds
     */
    function hide_recaptcha_fields() {
        recaptcha_fields_to_handle.forEach((field) => {
            $(field).parents("tr").hide();
            $(field).attr("type") == "text" && $(field).prop("required", false);
        });

        return;
    }

    /*
     * Function to to toggle required args
     */
    function recaptcha_fields_required(value) {
        recaptcha_fields_to_handle.forEach((field) => {
            $(field).prop("required", value);
        });
        return;
    }

    ///////////////////////////////////////////////////////
    // INIT THE DISPLAY
    ///////////////////////////////////////////////////////
    /*
     * Init. textarea status (visible or hidden)
     */
    $("textarea.hidden").hide();
    $("textarea.visible").show();

    /*
     * Init activate fields to hidden
     */
    hide_activate_fields();

    /*
     * Init birthday field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbbirthday").is(":checked")) {
        hide_birthday_fields();
    }

    /*
     * Init gender field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbgender").is(":checked")) {
        hide_gender_fields();
    }

    /*
     * Init language field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cblanguage").is(":checked")) {
        hide_language_fields();
    }

    /*
     * Init names field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbcustom1").is(":checked")) {
        hide_custom1_fields();
    }

    /*
     * Init names field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbcustom2").is(":checked")) {
        hide_custom2_fields();
    }

    /*
     * Init names field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbcustom3").is(":checked")) {
        hide_custom3_fields();
    }

    /*
     * Init names field to visible or hidden (HTML visible by default)
     */
    if (!$("#probance-optin_banner-cbnames").is(":checked")) {
        hide_names_fields();
    }

    /*
     * Init recaptcha fields to visible or hidden and set required to true or false
     */
    if (!$("#probance-optin_banner-cbrecaptcha").is(":checked")) {
        hide_recaptcha_fields();
        recaptcha_fields_required(false);
    } else {
        recaptcha_fields_required(true);
    }

    ///////////////////////////////////////////////////////
    // EVENT LISTENERS
    ///////////////////////////////////////////////////////
    /*
     * Event listener to hide/show name fields
     */
    $("input[data-type='activate']").click(function (e) {
        if (debug == 1) console.log("Click");
        if (debug == 1) console.log(e);

        var idToToggle = e.target.attributes["data-change"].nodeValue;

        $(`input#${idToToggle}`).prop("checked", !$(`input#${idToToggle}`).prop("checked"));
    });

    /*
     * Event listener to hide/show name fields
     */
    $("#probance-optin_banner-cbnames").change(function () {
        if ($(this).is(":checked")) show_names_fields();
        else hide_names_fields();
    });

    /*
     * Event listener to hide/show birthday fields
     */
    $("#probance-optin_banner-cbbirthday").change(function () {
        if ($(this).is(":checked")) show_birthday_fields();
        else hide_birthday_fields();
    });

    /*
     * Event listener to hide/show gender fields
     */
    $("#probance-optin_banner-cbgender").change(function () {
        if ($(this).is(":checked")) show_gender_fields();
        else hide_gender_fields();
    });

    /*
     * Event listener to hide/show custom fields
     */
    $("#probance-optin_banner-cbcustom1").change(function () {
        if ($(this).is(":checked")) show_custom1_fields();
        else hide_custom1_fields();
    });

    /*
     * Event listener to hide/show custom fields
     */
    $("#probance-optin_banner-cbcustom2").change(function () {
        if ($(this).is(":checked")) show_custom2_fields();
        else hide_custom2_fields();
    });

    /*
     * Event listener to hide/show custom fields
     */
    $("#probance-optin_banner-cbcustom3").change(function () {
        if ($(this).is(":checked")) show_custom3_fields();
        else hide_custom3_fields();
    });

    /*
     * Event listener to hide/show language fields
     */
    $("#probance-optin_banner-cblanguage").change(function () {
        if ($(this).is(":checked")) show_language_fields();
        else hide_language_fields();
    });

    /*
     * Event listener to hide/show recaptcha fields
     */
    $("#probance-optin_banner-cbrecaptcha").change(function () {
        if ($(this).is(":checked")) {
            show_recaptcha_fields();
            recaptcha_fields_required(true);
        } else {
            hide_recaptcha_fields();
            recaptcha_fields_required(false);
        }
    });

    $(".select_hook").change(function () {
        id = $(this).attr("id");

        if ($(this).val() == "0") {
            $(`#${id}-trigger-block-text`).show();
        } else {
            $(`#${id}-trigger-block-text`).hide();
        }
    });

    jQuery(".select_hook").change(function () {
        id = jQuery(this).attr("id");

        console.log(id);

        if (jQuery(this).val() == "0") {
            $(`#${id}-advanced-block-text`).show();
        } else {
            $(`#${id}-advanced-block-text`).hide();
        }
    });

    /*
     * Event listener to handle the "Properties" button in main admin window
     * It opens the properties pop-up assoiciated to the button
     */
    // Cancel redirection due to the submit action
    $(
        'input[name="btn-open-properties"], input[name="btn-open-translations"], input[name="btn-open-options-values"], input[name="btn-open-api-contact"], input[name="btn-open-hook-trigger"]'
    ).on("submit", function () {
        return false;
    });
    $(
        'input[name="btn-open-properties"], input[name="btn-open-translations"], input[name="btn-open-options-values"], input[name="btn-open-api-contact"], input[name="btn-open-hook-trigger"]'
    ).click(function (e) {
        e.preventDefault();

        var idInput = e.target.id;

        dataType = e.target.dataset.type;

        if (debug == 1) console.log(`Replace "-btn-open-${dataType}" by "" in ${idInput}`);

        var popupTargeted = "div#" + idInput.replace(`-btn-open-${dataType}`, "") + `-block-${dataType}`;

        if (debug == 1) console.log("Click on open button");
        if (debug == 1) console.log(popupTargeted);

        $(popupTargeted).css("display", "flex");
        $("body.wp-admin").css("overflow", "hidden");

        return false;
    });

    /*
     * Event listener to handle the "Close" button in the properties pop-up
     */
    // Cancel redirection due to the submit action
    $(
        'input[name="close-block-properties"], input[name="close-block-translations"], input[name="close-block-options-values"], input[name="close-block-api-contact"], input[name="close-block-hook-trigger"]'
    ).on("submit", function () {
        return false;
    });
    $(
        'input[name="close-block-properties"], input[name="close-block-translations"], input[name="close-block-options-values"], input[name="close-block-api-contact"], input[name="close-block-hook-trigger"]'
    ).click(function (e) {
        if (debug == 1) console.log("Click on close button");

        // Change css properties
        $('div[data-type="block-popup"]').css("display", "none");
        $("body.wp-admin").css("overflow", "visible");

        return false;
    });

    /*
     * Event listener to handle the "Save" button in the properties pop-up
     */
    // Cancel redirection due to the submit action
    $(
        'input[name="save-block-properties"], input[name="save-block-translations"], input[name="save-block-options-values"], input[name="save-block-api-contact"], input[name="save-block-hook-trigger"]'
    ).on("submit", function (e) {
        return false;
    });
    $(
        'input[name="save-block-properties"], input[name="save-block-translations"], input[name="save-block-options-values"], input[name="save-block-api-contact"], input[name="save-block-hook-trigger"]'
    ).click(function (e) {
        if (debug == 1) console.log("Click on save button");

        // Variables
        var stop = false;
        var idInput = e.target.id;
        var dataType = e.target.dataset.type;
        var commonId = idInput.replace(`-save-block-${dataType}`, "");
        var valuesToSave = new Array();
        var optionsToSave = new Array();

        if (debug == 1) {
            console.log(idInput);
            console.log(dataType);
            console.log(commonId);
        }

        if (dataType == "hook-trigger") {
            // Stock each options and textarea values into arrays
            $(`div[name="block-${dataType}"] select[id^=${commonId}]`).each(function () {
                var valueToSave = (
                    $(this).val().trim() == "0"
                        ? $(`div[name="block-${dataType}"] input#${commonId}-hook-trigger-advanced`).val()
                        : $(this).val()
                )
                    .trim()
                    .toLowerCase();

                if (debug == 1) console.log(`Save option ${$(this).attr("id")} with value ${valueToSave}`);

                var regex = /^[a-z_]+$/;

                if (valueToSave === "" || !regex.test(valueToSave)) {
                    $(`input#${commonId}-hook-trigger-advanced`).text("Incorrect hook name !").css("color", "red");

                    stop = true;
                } else {
                    $(`input#${commonId}-hook-trigger-advanced`).css("color", "black");
                }

                valuesToSave.push(valueToSave);
                optionsToSave.push($(this).attr("id"));

                if (debug == 1) console.log($(this).val());
                if (debug == 1) console.log($(this).attr("id"));
            });
        } else {
            // Stock each options and textarea values into arrays
            $(`div[name="block-${dataType}"] textarea[id^=${commonId}]`).each(function () {
                var valueToSave =
                    $(this).val().trim() == "" &&
                    $(this).data("default-value") != undefined &&
                    $(this).data("default-value") != null
                        ? $(this).data("default-value")
                        : $(this).val();

                if (debug == 1) console.log(`Save option ${$(this).attr("id")} with value ${valueToSave}`);

                valuesToSave.push(valueToSave);
                optionsToSave.push($(this).attr("id"));

                if (debug == 1) console.log($(this).val());
                if (debug == 1) console.log($(this).attr("id"));
            });
        }

        if (stop) return false;

        if (debug == 1) {
            console.log("URL for AJAX : " + path);
            console.log("Values to save : " + valuesToSave);
            console.log("Options to save : " + optionsToSave);
        }

        /*
         * POST REQUEST -> admin_load_properties or admin_load_translations.
         * SERVER SIDE handle by the probance_submit_update_properties or probance_submit_update_translations function into probance-optin.php
         */
        $.ajax({
            url: path,
            type: "POST",
            data: {
                action: `admin_load_option`,
                values: valuesToSave,
                options: optionsToSave,
            },
        })
            .done(function () {
                if (debug == 1) console.log("POST REQUEST : success");
            })
            .fail(function () {
                if (debug == 1) console.log("POST REQUEST : failed");
            });

        $('div[data-type="block-popup"]').css("display", "none");
        $("body.wp-admin").css("overflow", "visible");

        return false;
    });

    /*
     * Event listener to toggle textareas on click to option buttons
     */
    // Cancel redirection due to the submit action
    $(
        "a[id*=-btn-toggle-properties-], a[id*=-btn-toggle-translations-], a[id*=-btn-toggle-options-values-], a[id*=-btn-toggle-options-values-]"
    ).on("submit", function () {
        return false;
    });
    $(
        "a[id*=-btn-toggle-properties-], a[id*=-btn-toggle-translations-], a[id*=-btn-toggle-options-values-], a[id*=-btn-toggle-options-values-]"
    ).click(function (e) {
        e.preventDefault();

        // Variables
        var idA = e.target.id;
        var dataType = e.target.dataset.type;
        var idElements = idA.substr(0, idA.search(`-btn-toggle-${dataType}`));
        if (dataType == "options-values") {
            var id = idA.replace(`btn-toggle-`, "");
        } else {
            var id = idA.replace(`btn-toggle-${dataType}-`, "");
        }
        // var newLabel = `${e.target.text} > ${dataType.capitalize()}`;

        if (debug == 1) {
            console.log("button ID : " + idA);
            console.log("common ID : " + idElements);
            console.log("textarea ID : " + id);
            console.log("dataType : " + dataType);
            console.log(`block : div#${idElements}-block-${dataType}`);
            console.log(e);
        }

        // $(`div#${idElements}-block-${dataType} label.${dataType}-panel`).text(newLabel);
        // Handle changing class on the link (option button)
        $(`div#${idElements}-block-${dataType} a[id^=${idElements}]`).removeClass("button-primary");
        $("#" + idA).addClass("button-primary");

        // Handle changing hide/show of the textarea
        $(
            `div#${idElements}-block-${dataType} textarea[id^=${idElements}],div#${idElements}-block-${dataType} div[id^=${idElements}]`
        ).hide();
        $(
            `div#${idElements}-block-${dataType} textarea[id^=${idElements}],div#${idElements}-block-${dataType} div[id^=${idElements}]`
        ).addClass("hidden");
        $(
            `div#${idElements}-block-${dataType} textarea[id^=${idElements}],div#${idElements}-block-${dataType} div[id^=${idElements}]`
        ).removeClass("visible");

        $("#" + id).show();
        $("#" + id).addClass("visible");
        $("#" + id).removeClass("hidden");

        return false;
    });

    $("input.add_lang_btn").click(function (e) {
        e.preventDefault();

        var parentID = e.target.parentNode.id;
        var select = $(`div#${parentID} select`)[0];

        if (debug == 1) {
            console.log(`Parent ID : ${parentID}`);
            console.log(`Select lang : ` + select.value);
        }

        if (select.value == "0") {
            if (debug == 1) {
                console.log(`No language selected`);
            }
        } else {
            language = select.value;

            /*
             * POST REQUEST -> admin_load_properties or admin_load_translations.
             * SERVER SIDE handle by the probance_submit_update_properties or probance_submit_update_translations function into probance-optin.php
             */
            $.ajax({
                url: path,
                type: "POST",
                data: {
                    action: `admin_add_language`,
                    value: language,
                    option: "probance-optin-languages",
                },
            })
                .done(function () {
                    if (debug == 1) console.log("POST REQUEST : success");

                    // refresh the page
                    location.reload();
                })
                .fail(function () {
                    if (debug == 1) console.log("POST REQUEST : failed");
                });
        }
    });

    // When clicking on test api contact button => test probance api contact
    $("#probance-test-API-button").click(function (e) {
        alert("Click ok and wait for api response!");

        // Prevent from saving options and reloading the page
        e.preventDefault();

        // Get current page api contact parameters
        let projectname = $("#probance-optin_api-projectName").val();
        let apiaccount = $("#probance-optin_api-account").val();
        let apilogin = $("#probance-optin_api-login").val();
        let apipasswd = $("#probance-optin_api-passwd").val();
        let server = $("#probance-optin_api-infra").val();
        let email = $("#probance-testmail").val();

        /*
         * POST REQUEST -> admin_testAPIContact
         * SERVER SIDE handle by the probance_test_api_contact function in Ajax.php
         */
        $.ajax({
            url: path,
            type: "POST",
            data: {
                action: `admin_testAPIContact`,
                projectname: projectname,
                apiaccount: apiaccount,
                apilogin: apilogin,
                apipasswd: apipasswd,
                server: server,
                email: email,
            },
        })
            .done(function (result) {
                if (debug == 1) {
                    console.log("POST REQUEST : success");
                    console.log("Result optin test api contact:");
                    console.log(result);
                }

                // Create alert popup
                if (result.http_code === 200 && result.api_contact.status !== "ERROR") {
                    alert("Success! Api contact credentials are working!");
                    console.log("Result from api contact:\n" + JSON.stringify(result.api_contact));
                } else {
                    // Create temporay div to extract html text returned by contact API
                    let tempDiv = document.createElement("div");
                    tempDiv.innerHTML = result.api_contact;
                    // Extract text from html
                    let textContent = tempDiv.textContent || tempDiv.innerText;

                    alert(
                        "Error... Api contact credentials might be incorrect!" +
                            "\nYou can find more information in browser console."
                    );
                    try {
                        const retourBody = JSON.stringify(result.api_contact);
                        console.log(
                            "Http code:\n " + result.http_code + "   \nResult from api contact:\n" + retourBody
                        );
                    } catch (e) {
                        console.log(
                            "Http code:\n " + result.http_code + "\nResult from api contact:\n" + result.api_contact
                        );
                    }
                }
            })
            .fail(function () {
                if (debug == 1) console.log("POST REQUEST : failed");
            });
    });
});
