<?php


/**
 * @package probance-optin
 */

/* Classe contenant les fonctions permettant d'appeler l'API REST Probance API contact
 * 
 * Les URL sont du type http://xxx.probance.com/rt/api/resource/client/xx/search?prenom={prenom}&email={email}
 * avec xxx = début de l'URL du projet et xx = xxx si compte principal, xxx_souscompte pour un sous compte
 * 
 * La liste des paramètres à passer aux fonctions est définie dans le PPM correspondant
 */

namespace ProbanceOptin\Common;

class PmailAPI 
{
    public $token;
    public $infra;
	public $debug;

	/**
	 * Instiate ProbanceAPI class
	 * @param string $token	    : Probance API PMAIL token
	 * @param string $url		: Probance url
	 * @param string $debug		: debug
	 */
    public function __construct()
    {

		/*
        * Retrieve API parameters
        */
        try{
			$this->token=get_option('probance-optin_banner-pmail-token');
            switch (get_option('probance-optin_api-infra'))
            {
                case 'my-probance.one':
                    $this->url="https://www.probancemail.com/rest/v2/send/?token=" . $this->token;
                    break;
        
                case 'probance.ca':
                    $this->url="https://www-ca.probancemail.com/rest/v2/send/?token=" . $this->token;
                    break;
        
                case 'probance.jp':
                    $this->url="https://www-jp.probancemail.com/rest/v2/send/?token=" . $this->token;
                    break;            
            }
			$this->debug=get_option('probance-optin_api-cbdebug');
        }catch(Exception $e){
            Utils::write_log('[PROBANCE - optin] Erreur récupération option API : '.$e);
        }
    }

    public function send_campaign($payload)
    {
        $payload=json_encode($payload);

        $curl = curl_init();
        
        if ($this->debug == 1) Utils::write_log('[PROBANCE - PMAIL] payload : ' . $payload);

        $header=array('Content-Type: application/json', 'Content-Length: ' . strlen($payload));
        
        curl_setopt_array($curl, array(
        CURLOPT_URL => $this->url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>$payload,
        CURLOPT_HTTPHEADER =>$header,
        ));
        
        $response = curl_exec($curl);
    
        curl_close($curl);

        if ($this->debug == 1) Utils::write_log('[PROBANCE - PMAIL] response : ' . $response);
    }


	
}

?>