<?php

/**
 * @package probance-popup
 */

namespace ProbanceOptin\Popup;

use  ProbanceOptin\Common\Utils;
use  ProbanceOptin\Common\ProbancePopupAPI;
/*
* 
*/

class Popup
{
    public $popup_name = "probance_popup";
    public $permalien = '';

    function __construct()
    {

        // Check si le plugin est activé
        if (get_option('initial_popup_id', "0") == "0") {
            add_action('init', array($this, 'create_initial_popup'));
        }

        // Déclaration du custom type Pop Up
        add_action('init', array($this, 'custom_post_type'));

        // Modification du menu pour avoir un menu Probance Pop-Ups customisé
        add_action('admin_menu', array($this, 'popup_customization_page'));

        // Sous menu Custom CSS
        add_action('admin_menu', array($this, 'custom_css_menu_page'));

        // Save custom CSS
        add_action('admin_post_save_custom_css', array($this, 'save_custom_css'));

        // Meta boxes sont les parametres personnalisé tel que les pages d'affichage, le style de la pop-up, etc
        add_action('add_meta_boxes', array($this, 'popup_meta_box'));

        // Fonction de sauvegarde des paramètres de la pop-up
        add_action('save_post', array($this, 'save_popup_meta'));

        // La pop-up est affiché dans tous les footer (la gestion page par page est géré dans la fonction display_popup)
        add_action('wp_footer', array($this, 'display_website_popup'));

        add_filter('post_type_link', array($this, 'custom_post_type_permalink'), 10, 3);

        // register_activation_hook(__FILE__, array( $this, 'create_popup_page_preview_on_activation'));
        // register_deactivation_hook(__FILE__, array( $this, 'delete_popup_page_preview_on_deactivation'));


    }


    // Modifier le permalien d'une publication personnalisée
    function custom_post_type_permalink($permalink, $post, $leavename)
    {
        // Vérifier si la publication est de type 'probance_popup'
        if ($post->post_type == 'probance_popup') {
            // Modifier le permalien selon vos besoins
            $permalink = home_url($this->permalien);
        }

        return $permalink;
    }


    // Fonction pour créer une page lors de l'activation du plugin
    // function create_popup_page_preview_on_activation() {
    //     // Vérifier si la page existe déjà
    //     $popup_page = get_page_by_path($this->permalien);

    //     // Si la page n'existe pas, la créer
    //     if (!$popup_page) {
    //         // Créer une nouvelle page
    //         $page_id = wp_insert_post(array(
    //             'post_title'    => 'Probance Pop-up Preview Page',
    //             'post_name'     => $this->permalien,
    //             'post_type'     => 'page',
    //             'post_status'   => 'private',
    //         ));

    //         // Ajouter du contenu à la page si nécessaire
    //         // update_post_meta($page_id, 'meta_key', 'meta_value');
    //     }
    // }

    // // Fonction pour supprimer la page lors de la désactivation du plugin
    // function delete_popup_page_preview_on_deactivation() {
    //     // Récupérer l'ID de la page avec le permalien spécifié
    //     $popup_page = get_page_by_path($this->permalien);

    //     // Si la page existe, la supprimer
    //     if ($popup_page) {
    //         wp_delete_post($popup_page->ID, true);
    //     }
    // }


    // Fonction pour afficher le contenu de la page "Custom CSS"
    function custom_css_page_content()
    {
        // Vérifiez les autorisations de l'utilisateur
        if (!current_user_can('manage_options')) {
            return;
        }

        // Récupérez le contenu CSS depuis le fichier unique
        $custom_css_content = get_option('custom_popup_styles');

        // Si aucun contenu n'est trouvé, utiliser un contenu CSS par défaut
        if (empty($custom_css_content)) {
            $custom_css_content = "/* Here your custom style for all Pop-Ups */";
        }

        // Affichez le formulaire de méta box pour éditer le CSS
?>
        <div class="wrap">
            <h2>Custom CSS</h2>
            <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
                <input type="hidden" name="action" value="save_custom_css">
                <textarea name="custom_css" rows="40" style="width: 100%;"><?php echo esc_textarea($custom_css_content); ?></textarea><br>
                <input type="submit" class="button-primary" value="Save CSS">
            </form>
        </div>
    <?php
    }

    // Fonction pour sauvegarder le contenu CSS
    function save_custom_css()
    {
        // Vérifiez si le formulaire a été soumis et si l'utilisateur dispose des autorisations nécessaires
        if (isset($_POST['custom_css']) && current_user_can('manage_options')) {
            // Écrivez le contenu CSS dans le fichier unique
            $css_content = wp_kses_post($_POST['custom_css']); // Sécuriser le contenu CSS

            update_option('custom_popup_styles', $css_content);

            // Rediriger vers la page Custom CSS après la sauvegarde
            wp_redirect(admin_url('edit.php?post_type=probance_popup&page=custom-css'));
        }
    }

    // Définition de notre custom post type : Popup
    function custom_post_type()
    {
        $labels = array(
            'name'               => 'Probance Pop-ups',
            'singular_name'      => 'Probance Pop-up',
            'menu_name'          => 'Probance Pop-ups',
            'name_admin_bar'     => 'Probance Pop-up',
            'add_new'            => 'Add New',
            'add_new_item'       => 'Add New Pop-up',
            'new_item'           => 'New Pop-up',
            'edit_item'          => 'Edit Pop-up',
            'view_item'          => 'Show Pop-up',
            'all_items'          => 'All Pop-ups',
            'search_items'       => 'Find Pop-ups',
            'parent_item_colon'  => 'Parent Pop-ups:',
            'not_found'          => 'No Pop-up found.',
            'not_found_in_trash' => 'No Pop-up found in trash.'
        );

        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array('slug' => $this->popup_name),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => null,
            'supports'           => null //array( 'title', 'editor', 'thumbnail', 'custom-fields' )
        );

        register_post_type($this->popup_name, $args);
    }

    function create_initial_popup()
    {

        Utils::write_log("[PROPANCE - POPUP] Create initial popup after the plugin activation.");
        // Définir les détails de la nouvelle pop-up
        $popup_details = array(
            'post_title'   => 'Probance : Welcome Popup',
            'post_content' => '<h1>Welcome !</h1>
            This is the content of the initial popup.',
            'post_status'  => 'publish',
            'post_type'    => $this->popup_name,
        );

        // Insérer la pop-up dans la base de données
        $popup_id = wp_insert_post($popup_details);

        // Enregistrer les paramètres par défaut
        if ($popup_id) {

            update_post_meta($popup_id, 'probance_popup_color', '#ffffff');
            update_post_meta($popup_id, 'probance_popup_delay', '3');
            update_post_meta($popup_id, 'probance_popup_trigger_type', 'delay');
            update_post_meta($popup_id, 'probance_popup_scroll_percentage', '30');
            update_post_meta($popup_id, 'probance_popup_days_between_display', '0');


            // Enregistrer l'ID de la pop-up créée dans les options pour référence future
            update_option('initial_popup_id', $popup_id);
        }
    }

    // Fonction de désactivation
    function delete_initial_popup()
    {

        Utils::write_log("[PROPANCE - POPUP] Delete initial popup after the plugin desactivation.");
        // Récupérer l'ID de la pop-up initiale
        $popup_id = get_option('initial_popup_id');

        if ($popup_id) {
            // Supprimer la pop-up
            wp_delete_post($popup_id, true);

            // Supprimer l'option enregistrée
            delete_option('initial_popup_id');
        }
    }


    // Surcharge du menu de la Pop-up
    function popup_customization_page()
    {

        $menu_slug = 'edit.php?post_type=' . $this->popup_name;

        // // Supprimez l'ancien menu
        // unset($submenu['edit.php?post_type='.$this->popup_name]);

        remove_menu_page($menu_slug);

        add_menu_page(
            'Personnaliser Pop-up',
            'Probance Pop-Ups', // Nom du menu
            'manage_options',
            $menu_slug,
            '',
            PLUGIN_OPTIN_URL . 'src/images/logo-icon.png',
            85
        );
    }

    // Fonction pour ajouter le sous-menu "Custom CSS"
    function custom_css_menu_page()
    {
        add_submenu_page(
            'edit.php?post_type=probance_popup', // Slug du post type où ajouter le sous-menu
            'Custom CSS', // Titre de la page
            'Custom CSS', // Titre du menu
            'manage_options', // Capacité requise pour accéder à la page
            'custom-css', // Slug de la page
            array($this, 'custom_css_page_content') // Fonction pour afficher le contenu de la page
        );
    }

    // Ajouter un champ de méta-box pour spécifier les pages où afficher la pop-up
    function popup_meta_box()
    {

        //  Page d'affichage
        add_meta_box(
            'popup_page_meta',
            'Displaying',
            array($this, 'popup_page_meta_callback'),
            $this->popup_name,
            'normal',
            'high'
        );

        //  Style
        add_meta_box(
            'popup_style_meta',
            'Custom Style',
            array($this, 'popup_style_meta_callback'),
            $this->popup_name,
            'normal',
            'high'
        );

        add_meta_box(
            'popup_image', // ID unique de la meta box
            'Image Settings', // Titre de la meta box
            array($this, 'custom_popup_image_settings_meta_box_callback'), // Fonction de rappel pour afficher le contenu de la meta box
            $this->popup_name, // Type de post où afficher la meta box (assurez-vous de remplacer 'popups' par le slug du type de post que vous utilisez)
            'normal', // Emplacement de la meta box (normal, side, advanced)
            'high' // Priorité de la meta box (high, core, default, low)
        );

        // add_meta_box(
        //     'popup_preview', // ID unique de la meta box
        //     'Preview', // Titre de la meta box
        //     array($this, 'popup_prview_meta_box_callback'), // Fonction de rappel pour afficher le contenu de la meta box
        //     $this->popup_name, // Type de post où afficher la meta box (assurez-vous de remplacer 'popups' par le slug du type de post que vous utilisez)
        //     'normal', // Emplacement de la meta box (normal, side, advanced)
        //     'high' // Priorité de la meta box (high, core, default, low)
        // );

    }



    // Image
    function custom_popup_image_settings_meta_box_callback($post)
    {
        // Afficher les champs de la meta box ici
        // Vous pouvez utiliser les fonctions WordPress pour récupérer et afficher les valeurs des champs
        // Par exemple :
    ?>
        <label for="popup_image">Upload image :</label><br>
        <input type="text" id="popup_image" name="popup_image" value="<?php echo esc_attr(get_post_meta($post->ID, 'popup_image', true)); ?>"><br>
        <button id="upload_popup_image_button" class="button">Upload</button><br>

        <label for="image_position">Image position :</label><br>
        <select id="image_position" name="image_position">
            <option value="none" <?php selected(get_post_meta($post->ID, 'image_position', true), 'none'); ?>>None</option>
            <option value="left" <?php selected(get_post_meta($post->ID, 'image_position', true), 'left'); ?>>Left</option>
            <option value="right" <?php selected(get_post_meta($post->ID, 'image_position', true), 'right'); ?>>Right</option>
        </select><br>

        <label for="image_width">Width :</label><br>
        <input type="text" id="image_width" name="image_width" value="<?php echo esc_attr(get_post_meta($post->ID, 'image_width', true)); ?>"><br>

        <label for="image_height">Height :</label><br>
        <input type="text" id="image_height" name="image_height" value="<?php echo esc_attr(get_post_meta($post->ID, 'image_height', true)); ?>"><br>
        <script>
            jQuery(document).ready(function($) {
                // Bouton de téléchargement d'image
                $('#upload_popup_image_button').click(function(e) {
                    e.preventDefault();
                    var custom_uploader = wp.media({
                        title: 'Choose an image',
                        button: {
                            text: 'Choose'
                        },
                        multiple: false // Autoriser la sélection de plusieurs fichiers ou non
                    });
                    custom_uploader.on('select', function() {
                        console.log('Choose ! ')
                        var attachment = custom_uploader.state().get('selection').first().toJSON();
                        $('input#popup_image').val(attachment.url);
                    });
                    custom_uploader.open();
                });
            });
        </script>

    <?php
    }

    // Popup Pages
    function popup_page_meta_callback($post)
    {
        $pages = get_post_meta($post->ID, 'probance_popup_pages', true);
        $enabled = get_post_meta($post->ID, 'probance_popup_enabled', true);
        $check_optin = get_post_meta($post->ID, 'probance_popup_check_optin', true);
        $activated = ($enabled === 'yes') ? 'activated' : '';
        $enabled = ($enabled === 'yes') ? 'checked="checked"' : '';
        $check_optin = ($check_optin === 'yes') ? 'checked="checked"' : '';
        $all_pages = get_pages();
        $langs_selected = get_post_meta($post->ID, 'probance_popup_langs', true);
        $site_langs = Utils::getLanguages();
    ?>
        <div class="input_block" style="display: flex; align-items: center;">
            <input type="checkbox" id="probance_popup_enabled" name="probance_popup_enabled" <?php echo $enabled; ?>>
            <label for="probance_popup_enabled">Enabled ? </label>
            <p style="color: green;margin-left: 10px;"><?php echo $activated; ?></p><br>
        </div>
        <br>
        <label for="probance_popup_pages"><b>Displayed on pages :</b></label><br>
        <input type="checkbox" id="popup_page_all_products_pages" name="probance_popup_pages[]" value="all_products_pages" <?php echo (in_array("all_products_pages", explode(',', $pages))) ? 'checked' : ''; ?>>
        <label for="popup_page_all_products_pages">All products pages</label><br>
        <?php foreach ($all_pages as $page) : ?>
            <input type="checkbox" id="popup_page_<?php echo $page->ID; ?>" name="probance_popup_pages[]" value="<?php echo $page->ID; ?>" <?php echo (in_array($page->ID, explode(',', $pages))) ? 'checked' : ''; ?>>
            <label for="popup_page_<?php echo $page->ID; ?>"><?php echo $page->post_title; ?></label><br>
        <?php endforeach; ?>
        <br>
        <label><b>Resctrict on lang* :</b></label><br>
        <?php foreach ($site_langs as $index => $lang) : ?>
            <input type="checkbox" id="popup_lang_<?php echo $index; ?>" name="probance_popup_langs[]" value="<?php echo $lang ?>" <?php echo (in_array($lang, explode(',', $langs_selected))) ? 'checked' : ''; ?>>
            <label for="popup_lang_<?php echo $lang; ?>"><?php echo $lang; ?></label><br>
        <?php endforeach; ?>
        <span>* if no lang is restricted, the popup will be shown in all lang.</span>
        <br>
        <br>
        <label for="probance_popup_check_optin" style="cursor: default;"><b>Check optin :</b></label>
        <div class="input_block" style="display: flex; align-items: center;">
            <input type="checkbox" id="probance_popup_check_optin" name="probance_popup_check_optin" <?php if (! is_plugin_active('probance-optin/probance-optin.php')) {
                                                                                                            echo "disabled";
                                                                                                        } else {
                                                                                                            echo $check_optin;
                                                                                                        } ?>>
            <p>Enable this option if you do not want to display the popup when the client is already opted-in.</p></br>
            <?php if (! is_plugin_active('probance-optin/probance-optin.php')) echo "<p style='color: red; font-weight: bold;'>To use this option you have to install probance-optin plugin.</p>"; ?>
        </div>
        <br>
    <?php


    }

    // Popup Pages
    function popup_style_meta_callback($post)
    {

        // $height = get_post_meta($post->ID, 'probance_popup_height', true);
        // $width = get_post_meta($post->ID, 'probance_popup_width', true);
        $color = get_post_meta($post->ID, 'probance_popup_color', true);
        $delay = get_post_meta($post->ID, 'probance_popup_delay', true);
        $trigger_type = get_post_meta($post->ID, 'probance_popup_trigger_type', true);
        $time_unit = get_post_meta($post->ID, 'probance_popup_time_unit', true);
        $scroll_percentage = get_post_meta($post->ID, 'probance_popup_scroll_percentage', true);
        $days_between_display = get_post_meta($post->ID, 'probance_popup_days_between_display', true);

    ?>

        <!-- <label for="probance_popup_height">Pop-up Height (px) :</label>
            <input type="number" id="probance_popup_height" name="probance_popup_height" value=""><br>

            <label for="probance_popup_width">Pop-up Width (px) :</label>
            <input type="number" id="probance_popup_width" name="probance_popup_width" value=""><br> -->

        <label for="probance_popup_color">Background Color :</label>
        <input type="color" id="probance_popup_color" name="probance_popup_color" value="<?php echo esc_attr($color); ?>"><br>

        <label for="probance_popup_trigger_type">Displaying Trigger :</label>
        <select id="probance_popup_trigger_type" name="probance_popup_trigger_type">
            <option value="delay" <?php selected($trigger_type, 'delay'); ?>>Delay</option>
            <option value="scroll" <?php selected($trigger_type, 'scroll'); ?>>Scroll</option>
            <option value="manual" <?php selected($trigger_type, 'manual'); ?>>Manual</option>
        </select><br>

        <label for="probance_popup_delay">Delay (seconds) :</label>
        <input type="number" id="probance_popup_delay" name="probance_popup_delay" value="<?php echo esc_attr($delay); ?>"><br>

        <label for="probance_popup_scroll_percentage">Scroll (percentage) :</label>
        <input type="number" id="probance_popup_scroll_percentage" name="probance_popup_scroll_percentage" value="<?php echo esc_attr($scroll_percentage); ?>"><br>

        <div class="input_block" style="display: flex; align-items: center;">
            <label for="probance_popup_days_between_display">Frequency of display :</label>
            <input type="number" id="probance_popup_days_between_display" name="probance_popup_days_between_display" value="<?php echo esc_attr($days_between_display); ?>"><br>
            <select id="probance_popup_time_unit" name="probance_popup_time_unit">
                <option value="minutes" <?php selected($time_unit, 'minutes'); ?>>Minutes</option>
                <option value="hours" <?php selected($time_unit, 'hours'); ?>>Hours</option>
                <option value="days" <?php selected($time_unit, 'days'); ?>>Days</option>
            </select>
        </div>
<?php
    }

    // Sauvegarder la valeur du champ de méta-box
    function save_popup_meta($post_id)
    {

        Utils::write_log('POPUP DEBUG ? ' . json_encode($_POST, true));

        //  Save Pages
        if (isset($_POST['probance_popup_pages'])) {
            update_post_meta($post_id, 'probance_popup_pages', implode(',', $_POST['probance_popup_pages']));
        } else {
            update_post_meta($post_id, 'probance_popup_pages', "");
        }

        //  Save Langs
        if (isset($_POST['probance_popup_langs'])) {
            update_post_meta($post_id, 'probance_popup_langs', implode(',', array_map('sanitize_text_field', $_POST['probance_popup_langs'])));
        } else {
            // No langs selected, put '' and it will show on every lang
            update_post_meta($post_id, 'probance_popup_langs', '');
        }

        if (isset($_POST['probance_popup_color'])) {
            update_post_meta($post_id, 'probance_popup_color', $_POST['probance_popup_color']);
        }

        if (isset($_POST['probance_popup_delay'])) {
            update_post_meta($post_id, 'probance_popup_delay', $_POST['probance_popup_delay']);
        }

        if (isset($_POST['probance_popup_trigger_type'])) {
            update_post_meta($post_id, 'probance_popup_trigger_type', $_POST['probance_popup_trigger_type']);
        }

        if (isset($_POST['probance_popup_scroll_percentage'])) {
            update_post_meta($post_id, 'probance_popup_scroll_percentage', $_POST['probance_popup_scroll_percentage']);
        }

        if (isset($_POST['probance_popup_enabled'])) {
            $enabled = ($_POST['probance_popup_enabled'] === 'on') ? 'yes' : 'no';
            update_post_meta($post_id, 'probance_popup_enabled', $enabled);
        } else {
            update_post_meta($post_id, 'probance_popup_enabled', 'no');
        }

        if (is_plugin_active('probance-optin/probance-optin.php') && isset($_POST['probance_popup_check_optin'])) {
            $check_optin = ($_POST['probance_popup_check_optin'] === 'on') ? 'yes' : 'no';
            update_post_meta($post_id, 'probance_popup_check_optin', $check_optin);
        } else {
            update_post_meta($post_id, 'probance_popup_check_optin', 'no');
        }

        if (isset($_POST['probance_popup_days_between_display'])) {
            update_post_meta($post_id, 'probance_popup_days_between_display', $_POST['probance_popup_days_between_display']);
        }

        if (isset($_POST['probance_popup_time_unit'])) {
            update_post_meta($post_id, 'probance_popup_time_unit', $_POST['probance_popup_time_unit']);
        }

        // Vérifiez si les champs ont été définis
        if (isset($_POST['popup_image'])) {
            // Mettez à jour la valeur des champs dans les meta données du post
            update_post_meta($post_id, 'popup_image', sanitize_text_field($_POST['popup_image']));
        }

        if (isset($_POST['image_position'])) {
            update_post_meta($post_id, 'image_position', sanitize_text_field($_POST['image_position']));
        }

        if (isset($_POST['image_width'])) {
            update_post_meta($post_id, 'image_width', sanitize_text_field($_POST['image_width']));
        }

        if (isset($_POST['image_height'])) {
            update_post_meta($post_id, 'image_height', sanitize_text_field($_POST['image_height']));
        }
    }

    // Fonction pour vérifier si une pop-up doit être affichée
    function display_website_popup()
    {
        // Afficher le contenu de la pop-up
        $this->display_popup(-1, "ON_SITE");
    }

    // Preview ON EDIT POP-UP SCREEN
    function popup_prview_meta_box_callback($post)
    {
        // Afficher le contenu de la pop-up
        $this->display_popup($post->ID, "PREVIEW_SIMPLIFY");
    }

    // Fonction pour vérifier si une pop-up doit être affichée
    function display_popup($popup_id = -1, $display_mode = "")
    {
        Utils::write_log("[PROPANCE - POPUP] tentative d'affichage de la popup");

        // Récupération de la liste des post de la popup
        $popups = get_posts(array(
            'post_type' => $this->popup_name,
            'posts_per_page' => -1,
        ));

        // Vérification du mode preview
        if (isset($_GET['preview']) && $_GET['preview'] === 'true') {

            // Si oui, récupérer la valeur de preview_id
            $popup_id = isset($_GET['preview_id']) ? $_GET['preview_id'] : -1;

            $display_mode = "PREVIEW_PAGE";
        }

        // On boucle sur la liste des popups
        foreach ($popups as $popup) {

            Utils::write_log("[PROPANCE - POPUP] POPUP : " . json_encode($popup, true));

            if ($popup_id != -1 && $popup_id != $popup->ID) continue; // Si un popup id est spécifié alors on affiche que la popup en question

            // Jump to next popup if current lang should not see the popup and we are not in PREVIEW_PAGE mode
            if (!$this->isCurrentLangAllowed($popup->ID) && $display_mode != "PREVIEW_PAGE") continue;

            $display_on_pages = get_post_meta($popup->ID, 'probance_popup_pages', true);
            // $height = get_post_meta($popup->ID, 'probance_popup_height', true);
            // $width = get_post_meta($popup->ID, 'probance_popup_width', true);
            $color = get_post_meta($popup->ID, 'probance_popup_color', true);
            $delay = get_post_meta($popup->ID, 'probance_popup_delay', true);
            $trigger_type = get_post_meta($popup->ID, 'probance_popup_trigger_type', true);
            $scroll_percentage = get_post_meta($popup->ID, 'probance_popup_scroll_percentage', true);
            $enabled = get_post_meta($popup->ID, 'probance_popup_enabled', true);
            $check_optin = get_post_meta($popup->ID, 'probance_popup_check_optin', true);
            $days_between_display = get_post_meta($popup->ID, 'probance_popup_days_between_display', true);
            $time_unit = get_post_meta($popup->ID, 'probance_popup_time_unit', true);

            Utils::write_log("[PROPANCE - POPUP] display_on_pages: " . $display_on_pages);
            Utils::write_log("[PROPANCE - POPUP] is product page: " . (is_product() ? "OUI" : "NON"));

            // Récupérer l'URL de l'image depuis les métadonnées du post
            $popup_image_url = get_post_meta($popup->ID, 'popup_image', true);
            $image_position = get_post_meta($popup->ID, 'image_position', true);
            $image_width = get_post_meta($popup->ID, 'image_width', true);
            $image_height = get_post_meta($popup->ID, 'image_height', true);

            // On vérifie si l'option check optin es activée, que le plugin optin est activé et que nous ne sommes pas en mode PREVIEW
            if ($popup_id == -1 && $check_optin == "yes" && is_plugin_active('probance-optin/probance-optin.php')) {
                Utils::write_log("[PROPANCE - POPUP] Check optin enabled and plugin optin activated.");

                $api = new ProbancePopupAPI();
                $result = $api->apicontact_getInfos(array('customer_id' => get_current_user_id()));
                $data = json_decode($result, true);

                if (isset($data['client']['optin_flag']) && $data['client']['optin_flag'] == '1') {
                    $optin = $data['client']['optin_flag'];
                    Utils::write_log('[PROBANCE - POPUP] Result for client (id:' . get_current_user_id() . ') is optin');
                    if (isset($optin) && $optin == '1') {
                        return "";
                    }
                } else {
                    Utils::write_log('[PROBANCE - POPUP] Result for client (id:' . get_current_user_id() . ') : is not optin.');
                }
            }

            // if ( $popup_id != -1 || $enabled == "yes" && $display_on_pages ) || in_array( get_the_ID(), explode( ',', $display_on_pages ) ) ) {
            if ( $popup_id != -1 || ($enabled == "yes" && $display_on_pages != "" && in_array(get_the_ID(), explode(',', $display_on_pages))) || (is_product() && in_array('all_products_pages', explode(',', $display_on_pages)))) {
                echo '<div id="probance_popup_overlay"
                    data-popupid="' . $popup->ID . '"
                    data-trigger="' . $trigger_type . '"
                    data-scroll-percentage="' . $scroll_percentage . '"
                    data-delay="' . $delay . '"
                    data-time-value="' . $days_between_display . '"
                    data-image-position="' . esc_attr($image_position) . '"
                    data-time-unit="' . $time_unit . '"
                >
                    <div id="probance_popup_' . $popup->ID . '"
                    class="probance_popup"
                    style="background-color: ' . $color . ';"
                    >
                        <span class="close-btn">&times;</span>' .
                    (esc_attr($image_position) != "none" ? '<div class="popup_image ' . esc_attr($image_position) . '">
                            <img src="' . esc_url($popup_image_url) . '" width="' . esc_attr($image_width) . '" height="' . esc_attr($image_height) . '" alt="Popup Image">
                        </div>' : '')
                    .
                    '<div id="probance_popup_content" ' . ($popup_id != -1 ? 'class="probance_popup_content_preview"' : '') . '>'
                    . (($popup_id != -1 && $display_mode == 'PREVIEW_SIMPLIFY') ? '<div><h1>Pop-up sample</h1></div><div><h3>This example is provided by Probance, it is not the real Pop-up.</h3></div><div></div><div></div><div></div><div></div>' : do_shortcode($popup->post_content)) .
                    '</div>
                    </div>
                </div>';
            }
        }
    }


    /**
     * Check if the current popup should be displayed in the current user lang
     * In case of empty selection, display the popup anyway
     * @param int $popupId id of the popup
     * @return bool true if popup should be displayed, otherwise false
     */
    protected function isCurrentLangAllowed($popupId)
    {

        $meta_data_lang =  get_post_meta($popupId, 'probance_popup_langs', true);
        // Popup is not lang restricted -> display the popup
        if ($meta_data_lang === "") {
            return true;
        }

        // Lang where the popup is displayed, get an array with lower case lang code
        $display_on_langs = explode(',', strtolower($meta_data_lang));
        $user_lang = Utils::getUserLanguage();

        if (in_array($user_lang, $display_on_langs)) {
            return true;
        }

        Utils::write_log("[PROPANCE - POPUP] Do not show popup for current user lang: " . $user_lang . " with allowed lang: " . json_encode($display_on_langs));
        return false;
    }
}

?>