<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Pages;

use ProbanceOptin\Common\Utils;
use ProbanceOptin\Common\ProbanceAPI;
use ProbanceOptin\Common\PmailAPI;
use ProbanceOptin\Data\Translations;
use ProbanceOptin\Base\EventManager;

class Newsletter
{
    public function register()
    {
        add_action('init', array($this, 'register_probance_optin_listener'));
        add_action('wp_ajax_load_newsletter_form', array($this, 'probance_submit_newletter_form'));
        add_action('wp_ajax_nopriv_load_newsletter_form', array($this, 'probance_submit_newletter_form'));

        // shortcode const

        if (!shortcode_exists(NEWSLETTER_ATTR['name'])) {
            add_shortcode(NEWSLETTER_ATTR['name'], array($this, 'probance_wbanner_shortcode'));
        } else {
            remove_shortcode(NEWSLETTER_ATTR['name']);
            add_shortcode(NEWSLETTER_ATTR['name'], array($this, 'probance_wbanner_shortcode'));
        }

        update_option('probance-optin_banner-lbshortcode', NEWSLETTER_ATTR['shortcode']);

        add_action('wp_enqueue_scripts', array($this, 'probance_newsletter_form_style'), 9999);
    }

    function register_probance_optin_listener()
    {
        add_action('probance_optin_submitted', array($this, 'handle_probance_optin_submitted'));
    }

    function handle_probance_optin_submitted($data)
    {
        // Code à exécuter lorsque l'événement 'optin_submitted' est déclenché
        error_log("Nouvel optin soumis : " . json_encode($data));
    }

    public function probance_wbanner_shortcode($atts = [], $content = null)
    {
        // Atts
        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
            $debug = 0;
        }

        // normalize attribute keys, lowercase
        $atts = array_change_key_case((array) $atts, CASE_LOWER);

        wp_nonce_field('probance-signin-newsletter', 'probance-newsletter-verif');

        // checkbox options 
        $names_checked = get_option('probance-optin_banner-cbnames');
        $birthday_checked = get_option('probance-optin_banner-cbbirthday');
        $gender_checked = get_option('probance-optin_banner-cbgender');
        $language_checked = get_option('probance-optin_banner-cblanguage');
        $custom1_checked = get_option('probance-optin_banner-cbcustom1');
        $custom2_checked = get_option('probance-optin_banner-cbcustom2');
        $custom3_checked = get_option('probance-optin_banner-cbcustom3');
        $recaptcha_checked = get_option('probance-optin_banner-cbrecaptcha');

        // checkbox options 
        $names_required = filter_var(get_option('probance-optin_banner-cbnames-required'), FILTER_VALIDATE_BOOLEAN);
        $birthday_required = filter_var(get_option('probance-optin_banner-cbbirthday-required'), FILTER_VALIDATE_BOOLEAN);
        $gender_required = filter_var(get_option('probance-optin_banner-cbgender-required'), FILTER_VALIDATE_BOOLEAN);
        $language_required = filter_var(get_option('probance-optin_banner-cblanguage-required'), FILTER_VALIDATE_BOOLEAN);
        $custom1_required = filter_var(get_option('probance-optin_banner-cbcustom1-required'), FILTER_VALIDATE_BOOLEAN);
        $custom2_required = filter_var(get_option('probance-optin_banner-cbcustom2-required'), FILTER_VALIDATE_BOOLEAN);
        $custom3_required = filter_var(get_option('probance-optin_banner-cbcustom3-required'), FILTER_VALIDATE_BOOLEAN);

        // Maintitle variables
        $maintitle_class = get_option('probance-optin_banner-lbtitle-edit-class');
        $maintitle_html_tag = (get_option('probance-optin_banner-lbtitle-edit-html-tag') !== '') ? get_option('probance-optin_banner-lbtitle-edit-html-tag') : $mainTitleHtmlTag;

        // Subtitle variables
        $subtitle_class = get_option('probance-optin_banner-lbsubtitle-edit-class');
        $subtitle_html_tag = (get_option('probance-optin_banner-lbsubtitle-edit-html-tag') !== '') ? get_option('probance-optin_banner-lbsubtitle-edit-html-tag') : $subTitleHtmlTag;
        $recaptcha_sitekey = get_option('probance-optin_banner-recaptchasitekey');

        // First name variables
        $fname_label_class = get_option('probance-optin_banner-lbfname-edit-label-class');
        $fname_input_class = get_option('probance-optin_banner-lbfname-edit-input-class');

        // Last name variables
        $lname_label_class = get_option('probance-optin_banner-lblname-edit-label-class');
        $lname_input_class = get_option('probance-optin_banner-lblname-edit-input-class');

        // Last name variables
        $birthday_label_class = get_option('probance-optin_banner-birthday-edit-label-class');
        $birthday_input_class = get_option('probance-optin_banner-birthday-edit-input-class');

        // Last name variables
        $gender_label_class = get_option('probance-optin_banner-gender-edit-label-class');
        $gender_input_class = get_option('probance-optin_banner-gender-edit-input-class');

        // Last name variables
        $language_label_class = get_option('probance-optin_banner-language-edit-label-class');
        $language_input_class = get_option('probance-optin_banner-language-edit-input-class');

        // Custom1 variables
        $custom1_label_class = get_option('probance-optin_banner-custom1-edit-label-class');
        $custom1_input_class = get_option('probance-optin_banner-custom1-edit-input-class');

        // Custom2s variables
        $custom2s_label_class = get_option('probance-optin_banner-custom2s-edit-label-class');
        $custom2s_input_class = get_option('probance-optin_banner-custom2s-edit-input-class');

        // Custom2 variables
        $custom2_label_class = get_option('probance-optin_banner-custom2-edit-label-class');
        $custom2_input_class = get_option('probance-optin_banner-custom2-edit-input-class');

        // Email variables
        $email_label_class = get_option('probance-optin_banner-lbemail-edit-label-class');
        $email_input_class = get_option('probance-optin_banner-lbemail-edit-input-class');

        // Button variables
        $btn_class = get_option('probance-optin_banner-lbbtn-edit-class');

        $two_cols = get_option('probance-optin_banner-cbtwocols');

        // Message Submit Form
        $conf_msg_style = get_option('probance-optin_banner-conf-message-edit-css-style');
        $err_msg_style = get_option('probance-optin_banner-conf-error-message-edit-css-style');

        // checkboxe optin
        $probanceCBStyleCss = get_option('probance-optin_webel-cblabel-edit-css-style');

        $user_locale = Utils::getUserLanguage();

        $arr = Translations::getTranslatedFields('newsletter', $user_locale);
        $arr2 = Translations::getTranslatedFields('optin', $user_locale);

        if ($arr['probance-optin_banner-gender-options-values'] != null) {
            $genders = explode(';', $arr['probance-optin_banner-gender-options-values']);
        }

        $langs = Utils::getLanguages();

        $user_locale_maj = (strtoupper($user_locale) != null && strtoupper($user_locale) != "" ? strtoupper($user_locale) : 'default');

        // Supprime la langue spécifiée si elle est présente dans le tableau
        if (($key = array_search($user_locale_maj, $langs)) !== false && $user_locale_maj != 'default') {
            unset($langs[$key]);
        }

        // Réorganise les clés du tableau après suppression de la langue spécifiée
        $langs = array_values($langs);

        // Ajoute la langue spécifiée en premier index du tableau
        if ($user_locale_maj != 'default') {
            array_unshift($langs, $user_locale_maj);
        }

        if ($debug == 1) Utils::write_log("GENDERS : " . json_encode($genders));
        if ($debug == 1) Utils::write_log("LANGUAGES : " . json_encode($langs));

        // fields enabled
        $fname_enabled = isset($atts['fname']) ? filter_var($atts['fname'], FILTER_VALIDATE_BOOLEAN) : true;
        $lname_enabled = isset($atts['lname']) ? filter_var($atts['lname'], FILTER_VALIDATE_BOOLEAN) : true;
        $gender_enabled = isset($atts['gender']) ? filter_var($atts['gender'], FILTER_VALIDATE_BOOLEAN) : true;
        $birthday_enabled = isset($atts['birthday']) ? filter_var($atts['birthday'], FILTER_VALIDATE_BOOLEAN) : true;
        $language_enabled = isset($atts['language']) ? filter_var($atts['language'], FILTER_VALIDATE_BOOLEAN) : true;
        $custom1_enabled = isset($atts['custom1']) ? filter_var($atts['custom1'], FILTER_VALIDATE_BOOLEAN) : true;
        $custom2_enabled = isset($atts['custom2']) ? filter_var($atts['custom2'], FILTER_VALIDATE_BOOLEAN) : true;
        $custom3_enabled = isset($atts['custom3']) ? filter_var($atts['custom3'], FILTER_VALIDATE_BOOLEAN) : true;
        $optin_enabled = isset($atts['optin']) ? filter_var($atts['optin'], FILTER_VALIDATE_BOOLEAN) : true;
        $custom_tag = isset($atts['custom_tag']) ? $atts['custom_tag'] : get_option("probance-optin_banner-custom-tag");
        $campaign_id = isset($atts['campaign_id']) ? sprintf('%01d', $atts['campaign_id']) : '1';

        // Do we check the optin ? If true we check if the customer is optin using his id.
        $check_optin = isset($atts['check_optin']) ? filter_var($atts['check_optin'], FILTER_VALIDATE_BOOLEAN) : false;

        if ($campaign_id != '1' && $campaign_id != '2' && $campaign_id != '3') {
            $campaign_id = '1';
        }

        // Shortcode Args
        $form_id = (isset($atts['id']) ? strval($atts['id']) : '0');
        $probance_form_block_style = (isset($atts['block_style']) ? $atts['block_style'] : 'width: 100%;');
        $probance_form_style = (isset($atts['form_style']) ? $atts['form_style'] : '');

        if ($check_optin) {
            Utils::write_log('[PROBANCE - optin] Check optin activated. We check if the customer id already exists in Probance and we chec his optin_flag !');

            $api = new ProbanceAPI();
            $result = $api->apicontact_getInfos(array('customer_id' => get_current_user_id()));
            $data = json_decode($result, true);

            if (isset($data['client']['optin_flag']) && $data['client']['optin_flag'] == '1') {
                $optin = $data['client']['optin_flag'];
                Utils::write_log('[PROBANCE - optin] Result for client (id:' . get_current_user_id() . ') is optin');
                if (isset($optin) && $optin == '1') {
                    return "";
                }
            } else {
                Utils::write_log('[PROBANCE - optin] Result for client (id:' . get_current_user_id() . ') : is not optin.');
            }
        }

        $content .= '<div id="probance_form_block" style="' . $probance_form_block_style . '">
                        
                        <' . $maintitle_html_tag . ' class="p-nlform-maintitle ' . $maintitle_class . '">' . $arr['probance-optin_banner-lbtitle'] . '</' . $maintitle_html_tag . '>
                        <' . $subtitle_html_tag . ' class="p-nlform-subtitle ' . $subtitle_class . '">' . $arr['probance-optin_banner-lbsubtitle'] . '</' . $subtitle_html_tag . '>
                        <form id="probance_form_' . $form_id . '" data-probance-campaign-id="' . $campaign_id . '"  data-probance-form-id="' . $form_id . '" style="' . $probance_form_style . '" method="post" action="/">
                            
                            <div class="loader-overlay"><i class="fa fa-spinner fa-spin"></i></div>
                            <input type="hidden" id="g-token_' . $form_id . '" name="g-token" />';
        if (isset($custom_tag) && $custom_tag != "") $content .= '<input type="hidden" id="custom_tag_' . $form_id . '" name="custom_tag" value="' . $custom_tag . '"/>';

        if ($gender_checked && $arr['probance-optin_banner-gender-options-values'] != null && $gender_enabled) {

            $content .=     '<div class="fields_block">
                                <div class="gender_block">
                                    <label for="gender" class="p-nlform-gender-label ' . $gender_label_class . '" >' . $arr['probance-optin_banner-gender'] . ($gender_required ? " *" : "") . ' </label>
                                    <select id="probance_newsletter_gender_' . $form_id . '" name="gender" class="p-nlform-gender-input ' . $gender_input_class . '" ' . ($gender_required ? "required='true'" : "") . '>';
            foreach ($genders as $g) {
                $content .= '<option value="' . $g . '">' . $g . '</option>';
            }
            $content .=              '</select>
                                    <span class="probance_msg_wrong_gender hidden" data-type="message">' . $arr['probance-optin_banner-gender-error-msg'] . '</span>
                                </div>
                            </div>';
        }

        if ($names_checked) {

            $content .=     '<div class="fields_block">
                                <div class="names_block' . ($two_cols == 1 ? ' two-cols' : ' one-col') . '">';

            if ($fname_enabled) {
                $content .=     '<div class="fname_block">
                                        <label for="fname" class="p-nlform-fname-label ' . $fname_label_class . '" >' . $arr['probance-optin_banner-lbfname'] . ($names_required ? " *" : "") . '</label>
                                        <input type="text" id="probance_newsletter_fname_' . $form_id . '" name="fname" value="" class="p-nlform-fname-input ' . $fname_input_class . '" placeholder="' . $arr['probance-optin_banner-lbfname'] . '" ' . ($names_required ? "required='true'" : "") . '>
                                        <span class="probance_msg_wrong_fname hidden" data-type="message">' . $arr['probance-optin_banner-fname-error-msg'] . '</span>
                                    </div>';
            }

            if ($lname_enabled) {
                $content .= '<div class="lname_block">
                                        <label for="lname" class="p-nlform-lname-label ' . $lname_label_class . '">' . $arr['probance-optin_banner-lblname'] . ($names_required ? " *" : "") . '</label>
                                        <input type="text" id="probance_newsletter_lname_' . $form_id . '" name="lname" value="" class="p-nlform-lname-input ' . $lname_input_class . '" placeholder="' . $arr['probance-optin_banner-lblname'] . '" ' . ($names_required ? "required='true'" : "") . '>
                                        <span class="probance_msg_wrong_lname hidden" data-type="message">' . $arr['probance-optin_banner-lname-error-msg'] . '</span>
                                    </div>';
            }

            $content .=         '</div>  
                            </div>';
        }

        if ($birthday_checked && $birthday_enabled) {

            $content .=     '<div class="fields_block">
                                <div class="birthday_block">
                                    <div class="birthday_block">
                                        <label for="birthday" class="p-nlform-birthday-label ' . $birthday_label_class . '" >' . $arr['probance-optin_banner-birthday'] . ($birthday_required ? " *" : "") . '</label>
                                        <input type="date" id="probance_newsletter_birthday_' . $form_id . '" name="birthday" value="" class="p-nlform-birthday-input ' . $birthday_input_class . '" placeholder="' . $arr['probance-optin_banner-birthday'] . '" ' . ($birthday_required ? "required='true'" : "") . ' max="' . date('Y-m-d') . '">
                                        <span class="probance_msg_wrong_birthday hidden" data-type="message">' . $arr['probance-optin_banner-birthday-error-msg'] . '</span>
                                    </div>
                                </div>  
                            </div>';
        }

        if ($language_checked && $language_enabled) {

            $content .=     '<div class="fields_block">
                                <div class="language_block">
                                    <div class="language_block">
                                        <label for="language" class="p-nlform-language-label ' . $language_label_class . '" >' . $arr['probance-optin_banner-language'] . ($language_required ? " *" : "") . '</label>
                                        <select id="probance_newsletter_language_' . $form_id . '" name="language" class="p-nlform-language-input ' . $language_input_class . '" ' . ($language_required ? "required='true'" : "") . '>';
            foreach ($langs as $l) {
                $content .= '<option value="' . $l . '">' . $l . '</option>';
            }
            $content .=                 '</select>
                                        <span class="probance_msg_wrong_language hidden" data-type="message">' . $arr['probance-optin_banner-language-error-msg'] . '</span>
                                    </div>
                                </div>  
                            </div>';
        }

        if ($custom1_checked && $custom1_enabled) {
            $content .=     '<div class="fields_block">
                                <div class="custom1_block">
                                    <div class="custom1_block">
                                        <label for="custom1" class="p-nlform-custom1-label ' . $custom1_label_class . '" >' . $arr['probance-optin_banner-custom1'] . ($custom1_required ? " *" : "") . '</label>
                                        <input type="text" id="probance_newsletter_custom1_' . $form_id . '" name="custom1" value="" class="p-nlform-custom1-input ' . $custom1_input_class . '" placeholder="' . $arr['probance-optin_banner-custom1'] . '" ' . ($custom1_required ? "required='true'" : "") . '>
                                        <span class="probance_msg_wrong_custom1 hidden" data-type="message">' . $arr['probance-optin_banner-custom1-error-msg'] . '</span>
                                    </div>
                                </div>  
                            </div>';
        }

        if ($custom2_checked && $custom2_enabled) {
            $content .=     '<div class="fields_block">
                                <div class="custom2_block">
                                    <div class="custom2_block">
                                        <label for="custom2" class="p-nlform-custom2-label ' . $custom2_label_class . '" >' . $arr['probance-optin_banner-custom2'] . ($custom2_required ? " *" : "") . '</label>
                                        <input type="text" id="probance_newsletter_custom2_' . $form_id . '" name="custom2" value="" class="p-nlform-custom2-input ' . $custom2_input_class . '" placeholder="' . $arr['probance-optin_banner-custom2'] . '" ' . ($custom2_required ? "required='true'" : "") . '>
                                        <span class="probance_msg_wrong_custom2 hidden" data-type="message">' . $arr['probance-optin_banner-custom2-error-msg'] . '</span>
                                    </div>
                                </div>  
                            </div>';
        }

        if ($custom3_checked && $custom3_enabled) {
            $content .=     '<div class="fields_block">
                                <div class="custom3_block">
                                    <div class="custom3_block">
                                        <label for="custom3" class="p-nlform-custom3-label ' . $custom3_label_class . '" >' . $arr['probance-optin_banner-custom3'] . ($custom3_required ? " *" : "") . '</label>
                                        <input type="text" id="probance_newsletter_custom3_' . $form_id . '" name="custom3" value="" class="p-nlform-custom3-input ' . $custom3_input_class . '" placeholder="' . $arr['probance-optin_banner-custom3'] . '" ' . ($custom3_required ? "required='true'" : "") . '>
                                        <span class="probance_msg_wrong_custom3 hidden" data-type="message">' . $arr['probance-optin_banner-custom3-error-msg'] . '</span>
                                    </div>
                                </div>  
                            </div>';
        }

        $content .=     '<div class="email_block">
                                <label for="email" class="p-nlform-email-label ' . $email_label_class . '">' . $arr['probance-optin_banner-lbemail'] . ' *</label>
                                <input type="text" id="probance_newsletter_email_' . $form_id . '" name="email" class="p-nlform-email-input ' . $email_input_class . '" placeholder="' . $arr['probance-optin_banner-lbemail'] . '" required="true">
                                <span class="probance_msg_wrong_email hidden" data-type="message">' . $arr['probance-optin_banner-email-error-msg'] . '</span>
                            </div>  
                            <input type="hidden" id="probance_newsletter_info_fk_' . $form_id . '" name="info_fk"/>
                        ';

        //<span class="probance_msg_empty_email hidden" data-type="message">'.$arr['probance-optin_banner-email-empty-msg'].'</span>

        if (get_option('probance-optin_webel-cbnl-behave') == 1 && $optin_enabled)
            $content .= "<div id='probance_optin_cb_wrapper'><input type='checkbox' id='probance_optin_cb_nl_$form_id' style='$probanceCBStyleCss' name='probance_optin_cb_nl'/><span style='$probanceCBStyleCss'>" . $arr2['probance-optin_webel-cblabel'] . "</span></div>";

        $content .= '   
                        <div id="btn_block">
                            <input type="submit" id="probance_newsletter_submit_btn_' . $form_id . '" value="' . $arr['probance-optin_banner-lbbtn'] . '" class="p-nlform-btn-input' . $btn_class . '">
                            <div style="' . $conf_msg_style . '" class="probance_message_submit hidden" data-type="message">
                                <p class="message">' . $arr['probance-optin_banner-conf-message'] . '</p>
                                <p class="icon_close">x</p> 
                            </div>
                            <div style="' . $err_msg_style . '" class="probance_message_submit_faillure hidden" data-type="message">
                                <p class="message">' . $arr['probance-optin_banner-conf-error-message'] . '</p>
                                <p class="icon_close">x</p> 
                            </div>
                        </div>
                    </form>
                </div>';

        return $content;
    }

    public function register_external_optin_listener() {}

    public function probance_submit_newletter_form()
    {

        $api = new ProbanceAPI();

        // Création d'une instance de gestionnaire d'événements
        // $eventManager = new EventManager();

        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
            $debug = 0;
        }

        try {
            $recaptcha_thres_hold = (float) get_option('probance-optin_banner-recaptcha-threshold', '0.0');
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur récupération "probance-optin_banner-recaptcha-threshold" : ' . $e);
        }

        // Retrieving checkboxes to check reCAPTCHA is activated
        $recaptcha_checked = get_option('probance-optin_banner-cbrecaptcha');

        $recaptcha_error = 0;
        if ($debug == 1) Utils::write_log($_POST);

        // reCAPTCHA verification of the client-side token
        if ($recaptcha_checked == 1 && isset($_POST['g-token']) && $_POST['g-token'] != "") {
            if ($debug == 1) Utils::write_log('[PROBANCE - optin] reCAPTCHA is verifying the client-side token.');
            $secret = get_option('probance-optin_banner-recaptchaprivatekey');

            $checkUrl = 'https://www.google.com/recaptcha/api/siteverify?secret=' . $secret . '&response=' . $_POST['g-token'];
            $verifyResponse = file_get_contents($checkUrl);
            $responseData = json_decode($verifyResponse);

            if ($debug == 1) Utils::write_log('[PROBANCE - optin] Verifying recaptch with url  : ' . $checkUrl);
            if ($debug == 1) Utils::write_log('[PROBANCE - optin] reCAPTCHA response : ' . json_encode($responseData, true));

            if ($responseData->success) {
                if ($debug == 1) Utils::write_log('[PROBANCE - optin] reCAPTCHA response - [SUCCESS]');
                if($responseData->score <= $recaptcha_thres_hold )
                {
                    wp_send_json_error(["success" => false, "message" => "The current reCAPTCHA score for ".$_REQUEST['email']." is not permitted (".$responseData->score." <= ".$recaptcha_thres_hold.")"]);
                    if ($debug == 1) Utils::write_log("[PROBANCE - optin] The current reCAPTCHA score for ".$_REQUEST['email']." is not permitted (".$responseData->score." <= ".$recaptcha_thres_hold.")");
                    return false;
                }
            } else {
                if ($debug == 1) Utils::write_log('[PROBANCE - optin] reCAPTCHA response - [ERROR]');
                $recaptcha_error += 1;
                wp_send_json_error(["success" => false, "message" => "You seems to have a problem with reCaptcha v3. Please contact Probance Assist and try to disabled reCaptcha v3 option in the Probance Optin module.", "detail" => $responseData]);
                return false;
            }
        }


        if ($debug == 1)
            Utils::write_log('[PROBANCE - optin] NEWSLETTER FORM - BEGIN ###################################################################');
        /*
        * Retrieve form fields via l'AJAX js/probance_submit_newsletter.js
        */
        try {
            $email = $_REQUEST['email'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération de l\'email (' . $email . ') dans formulaire de Newsletter.');

            $fname = $_REQUEST['fname'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du prénom (' . $fname . ') dans formulaire de Newsletter.');

            $lname = $_REQUEST['lname'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du nom (' . $lname . ') dans formulaire de Newsletter.');

            $gender = $_REQUEST['gender'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du genre (' . $gender . ') dans formulaire de Newsletter.');

            $birthday = $_REQUEST['birthday'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération de l\'anniversaire (' . $birthday . ') dans formulaire de Newsletter.');

            $language = $_REQUEST['language'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération de la langue (' . $language . ') dans formulaire de Newsletter.');

            $custom1 = $_REQUEST['custom1'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du champ custom 1 (' . $custom1 . ') dans formulaire de Newsletter.');

            $custom2 = $_REQUEST['custom2'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du champ custom 2 (' . $custom2 . ') dans formulaire de Newsletter.');

            $custom3 = $_REQUEST['custom3'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du champ custom 3 (' . $custom3 . ') dans formulaire de Newsletter.');

            $campaign_id = $_REQUEST['campaign_id'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération de la campagne (' . $campaign_id . ').');

            $custom_tag = $_REQUEST['custom_tag'];

            if ($debug == 1)
                Utils::write_log('[PROBANCE - optin] Récupération du tag (' . $custom_tag . ').');

            if ($email == "vide" && $fname == "vide" && $lname == "vide") {
                Utils::write_log('HoneyPot a reçu une tentative de spam');

                wp_send_json_error(["success" => false, "message" => "Honey Pot has detected suspicious request.", "detail" => []]);
            }
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur dans la récupération des données du formulaire de Newsletter.');
        }

        $error = 0;

        /*
        * Retrieve API parameters
        */
        try {
            $apiprojectName = get_option('probance-optin_api-projectName');
            $apiaccount = get_option('probance-optin_api-account');
            $apiLogin = get_option('probance-optin_api-login');
            $apiPass = get_option('probance-optin_api-passwd');
            $apiInfra = get_option('probance-optin_api-infra');
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur récupération option API : ' . $e);
            $error = 1;
        }

        if ($error == 0) {

            //Call WP API 
            $user_id = get_current_user_id();
            $custom_fields = array();
            $custom_values = array();
            // Prepare array parameter
            $param = array('optin_flag' => 1);
            if ($email != null) {
                $key_email = get_option("probance-optin_banner-lbemail-api-contact");
                $param[$key_email] = $email;
            }

            if ($fname != null) {

                $key_fname = get_option("probance-optin_banner-lbfname-api-contact");
                $param[$key_fname] = $fname;
                array_push($custom_fields, $key_fname);
                array_push($custom_values, $fname);
            }

            if ($lname != null) {
                $key_lname = get_option("probance-optin_banner-lblname-api-contact");
                $param[$key_lname] = $lname;
                array_push($custom_fields, $key_lname);
                array_push($custom_values, $lname);
            }

            if ($gender != null) {
                $key_gender = get_option("probance-optin_banner-gender-api-contact");
                $param[$key_gender] = $gender;
                array_push($custom_fields, $key_gender);
                array_push($custom_values, $gender);
            }

            if ($birthday != null) {
                $key_birthday = get_option("probance-optin_banner-birthday-api-contact");
                $param[$key_birthday] = $birthday;
                array_push($custom_fields, $key_birthday);
                array_push($custom_values, $birthday);
            }

            if ($language != null) {
                $key_language = get_option("probance-optin_banner-language-api-contact");
                $param[$key_language] = $language;
                array_push($custom_fields, $key_language);
                array_push($custom_values, $language);
            }

            if ($custom1 != null) {
                $key_custom1 = get_option("probance-optin_banner-custom1-api-contact");
                $param[$key_custom1] = $custom1;
                array_push($custom_fields, $key_custom1);
                array_push($custom_values, $custom1);
            }

            if ($custom2 != null) {
                $key_custom2 = get_option("probance-optin_banner-custom2-api-contact");
                $param[$key_custom2] = $custom2;
                array_push($custom_fields, $key_custom2);
                array_push($custom_values, $custom2);
            }

            if ($custom3 != null) {
                $key_custom3 = get_option("probance-optin_banner-custom3-api-contact");
                $param[$key_custom3] = $custom3;
                array_push($custom_fields, $key_custom3);
                array_push($custom_values, $custom3);
            }

            if ($custom_tag != null) {
                $key_tag = get_option("probance-optin_banner-custom-tag-api-contact");
                $param[$key_tag] = $custom_tag;
                array_push($custom_fields, $key_tag);
                array_push($custom_values, $custom_tag);
            }

            // if($user_id!=0) $param['customer_id']=$user_id;

            if ($debug == 1) {
                foreach ($param as $key => $value) {
                    Utils::write_log('[PROBANCE - optin] paramètre(s) pour l\'API - ' . $key . ' : ' . $value);
                }
            }

            // Envoi du mail PMAIL
            if (isset($language) && $language!=''){
                $user_locale=strtolower($language);
            } else {
                $user_locale=Utils::get_user_preferred_language();
            }

            Utils::write_log('[PROBANCE - PMAIL] user_locale : ' . $user_locale);

            $pmail_settings = Translations::getTranslatedFields('pmail', $user_locale);

            Utils::write_log('[PROBANCE - PMAIL] object campaign : ' . json_encode($pmail_settings, true));
            Utils::write_log('[PROBANCE - PMAIL] Key data       : ' . json_encode($custom_fields, true));
            Utils::write_log('[PROBANCE - PMAIL] Values data       : ' . json_encode($custom_values, true));

            if (isset($pmail_settings)) {
                $pmail_token = $pmail_settings['probance-optin_banner-pmail-token'];
                $pmail_campaign = $pmail_settings['probance-optin_banner-pmail-newsubscriber-' . $campaign_id];
                $pmail_activated = (isset($pmail_settings['probance-optin_banner-pmail-newsubscriber-' . $campaign_id . '-cb']) && $pmail_settings['probance-optin_banner-pmail-newsubscriber-' . $campaign_id . '-cb'] == '1');

                if (isset($pmail_token) && $pmail_token != '') {
                    if ($pmail_activated) {
                        if (isset($pmail_campaign) && $pmail_campaign != '') {
                            $pmail_payload = array(
                                "campaign_external_id" => $pmail_campaign,
                                "custom_fields" => $custom_fields,
                                "recipients" => [
                                    array(
                                        "contact_id" => $_POST['email'],
                                        "email" => $_POST['email'],
                                        "custom_values" => $custom_values
                                    )
                                ]
                            );

                            (new PmailAPI())->send_campaign($pmail_payload);
                        } else {
                            Utils::write_log('[PROBANCE - PMAIL] New account campaign ID is missing.');
                        }
                    } else {
                        Utils::write_log('[PROBANCE - PMAIL] New account campaign is not enabled.');
                    }
                } else {
                    Utils::write_log('[PROBANCE - PMAIL] Pmail token is missing.');
                }
            } else {
                Utils::write_log('[PROBANCE - PMAIL] pmail settings not found');
            }

            /*
            * Block conditionnal update/create a customer
            */
            // Do we know the email ?
            if ($api->apicontact_exist(array('email' => $email))) {
                if ($debug == 1)
                    Utils::write_log('[PROBANCE - optin] on connait l\'email');

                //If yes we update the contact
                $result = $api->apicontact_update('email', $param);

                if ($debug == 1)
                    Utils::write_log('[PROBANCE - optin] API response : ' . $result[0]);

                Utils::write_log('[PROBANCE - optin] Trigger event "probance_optin_submitted".');
                do_action('probance_optin_submitted', ['email' => $email]);

                //  Création d'un cookie 
                $this->set_user_info_cookie($email);

                wp_send_json_success(["success" => true, "message" => "Client ($email) successfully updated.", "detail" => $param], 200);
            } else {
                if ($debug == 1)
                    Utils::write_log('[PROBANCE - optin] on connait pas l\'email, on crée le user');

                $param['registration_date'] = date('Y-m-d H:i:s');

                // Création du contact avec Prénom, Nom (si non null) date d'enregistrement, email et opt-in à 1          
                $result = $api->apicontact_create($param);

                if ($debug == 1)
                    Utils::write_log('[PROBANCE - optin] API response : ' . $result[0]);

                wp_send_json_success(["success" => true, "message" => "Client ($email) successfully created.", "detail" => $param], 200);
            }
        }
        if ($debug == 1)
            Utils::write_log('[PROBANCE - optin] NEWSLETTER FORM - END #####################################################################');
    }

    public function set_user_info_cookie($user_email)
    {

        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            Utils::write_log('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
            $debug = 0;
        }

        // Encoder les informations en base64
        $encoded_info = base64_encode(json_encode(array("user_email" => $user_email)));

        if ($debug == 1) Utils::write_log('[PROBANCE - optin] Création du cookie "Prob_Subscribe" : content(' . $encoded_info . ')');

        // Définir le cookie pour 5 minutes (300 secondes)
        setcookie('Prob_Subscribe', $encoded_info, time() + 300, COOKIEPATH, COOKIE_DOMAIN);

        // if (is_user_logged_in()) {

        //     Utils::write_log('[PROBANCE - optin] Le client est connecté on récupère son id.');

        //     $current_user = wp_get_current_user();
        //     $user_id = $current_user->ID;
        //     $user_email = $user_email;

        // }
    }

    public function probance_newsletter_form_style()
    {

        // Main title properties
        $maintitle_css = get_option('probance-optin_banner-lbtitle-edit-h-style');

        // Subtitle properties
        $subtitle_css = get_option('probance-optin_banner-lbsubtitle-edit-h-style');

        // First name properties
        $fname_input_css = get_option('probance-optin_banner-lbfname-edit-input-style');
        $fname_input_hover_css = get_option('probance-optin_banner-lbfname-edit-input-hover-style');
        $fname_input_focus_css = get_option('probance-optin_banner-lbfname-edit-input-focus-style');
        $fname_label_css = get_option('probance-optin_banner-lbfname-edit-label-style');

        // Last name properties
        $lname_input_css = get_option('probance-optin_banner-lblname-edit-input-style');
        $lname_input_hover_css = get_option('probance-optin_banner-lblname-edit-input-hover-style');
        $lname_input_focus_css = get_option('probance-optin_banner-lblname-edit-input-focus-style');
        $lname_label_css = get_option('probance-optin_banner-lblname-edit-label-style');

        // Birthday properties
        $birthday_input_css = get_option('probance-optin_banner-birthday-edit-input-style');
        $birthday_input_hover_css = get_option('probance-optin_banner-birthday-edit-input-hover-style');
        $birthday_input_focus_css = get_option('probance-optin_banner-birthday-edit-input-focus-style');
        $birthday_label_css = get_option('probance-optin_banner-birthday-edit-label-style');

        // Birthday properties
        $gender_input_css = get_option('probance-optin_banner-gender-edit-input-style');
        $gender_input_hover_css = get_option('probance-optin_banner-gender-edit-input-hover-style');
        $gender_input_focus_css = get_option('probance-optin_banner-gender-edit-input-focus-style');
        $gender_label_css = get_option('probance-optin_banner-gender-edit-label-style');

        // Language properties
        $language_input_css = get_option('probance-optin_banner-language-edit-input-style');
        $language_input_hover_css = get_option('probance-optin_banner-language-edit-input-hover-style');
        $language_input_focus_css = get_option('probance-optin_banner-language-edit-input-focus-style');
        $language_label_css = get_option('probance-optin_banner-language-edit-label-style');

        // Custom 1 properties
        $custom1_input_css = get_option('probance-optin_banner-custom1-edit-input-style');
        $custom1_input_hover_css = get_option('probance-optin_banner-custom1-edit-input-hover-style');
        $custom1_input_focus_css = get_option('probance-optin_banner-custom1-edit-input-focus-style');
        $custom1_label_css = get_option('probance-optin_banner-custom1-edit-label-style');

        // Custom 2 properties
        $custom2_input_css = get_option('probance-optin_banner-custom2-edit-input-style');
        $custom2_input_hover_css = get_option('probance-optin_banner-custom2-edit-input-hover-style');
        $custom2_input_focus_css = get_option('probance-optin_banner-custom2-edit-input-focus-style');
        $custom2_label_css = get_option('probance-optin_banner-custom2-edit-label-style');

        // Custom 3 properties
        $custom3_input_css = get_option('probance-optin_banner-custom3-edit-input-style');
        $custom3_input_hover_css = get_option('probance-optin_banner-custom3-edit-input-hover-style');
        $custom3_input_focus_css = get_option('probance-optin_banner-custom3-edit-input-focus-style');
        $custom3_label_css = get_option('probance-optin_banner-custom3-edit-label-style');

        // Email properties
        $email_input_css = get_option('probance-optin_banner-lbemail-edit-input-style');
        $email_input_hover_css = get_option('probance-optin_banner-lbemail-edit-input-hover-style');
        $email_input_focus_css = get_option('probance-optin_banner-lbemail-edit-input-focus-style');
        $email_label_css = get_option('probance-optin_banner-lbemail-edit-label-style');

        // Button properties
        $btn_css = get_option('probance-optin_banner-lbbtn-edit-css-style');
        $btn_hover_css = get_option('probance-optin_banner-lbbtn-edit-hover-style');
        $btn_focus_css = get_option('probance-optin_banner-lbbtn-edit-focus-style');

        // Error message properties
        $fname_error_css = get_option('probance-optin_banner-fname-error-msg-edit-css-style');
        $lname_error_css = get_option('probance-optin_banner-lname-error-msg-edit-css-style');
        $gender_error_css = get_option('probance-optin_banner-gender-error-msg-edit-css-style');
        $language_error_css = get_option('probance-optin_banner-language-error-msg-edit-css-style');
        $birthday_error_css = get_option('probance-optin_banner-birthday-error-msg-edit-css-style');
        $email_error_css = get_option('probance-optin_banner-email-error-msg-edit-css-style');
        $custom1_error_css = get_option('probance-optin_banner-custom1-error-msg-edit-css-style');
        $custom2_error_css = get_option('probance-optin_banner-custom2-error-msg-edit-css-style');
        $custom3_error_css = get_option('probance-optin_banner-custom3-error-msg-edit-css-style');


        // Conf. message properties
        $conf_message_css = get_option('probance-optin_banner-conf-message-edit-css-style');


        // CSS variable
        $css = ($maintitle_css != "" ? '.p-nlform-maintitle {' . $maintitle_css . '}
' : '') .
            ($subtitle_css != "" ? '.p-nlform-subtitle {' . $subtitle_css . '}
' : '') .
            ($fname_input_css != "" ? 'input.p-nlform-fname-input{' . $fname_input_css . '}
' : '') .
            ($fname_input_hover_css != "" ? 'input.p-nlform-fname-input:hover{' . $fname_input_hover_css . '}
' : '') .
            ($fname_input_focus_css != "" ? 'input.p-nlform-fname-input:focus{' . $fname_input_focus_css . '}
' : '') .
            ($fname_label_css != "" ? 'label.p-nlform-fname-label{' . $fname_label_css . '}
' : '') .
            ($birthday_input_css != "" ? 'input.p-nlform-birthday-input{' . $birthday_input_css . '}
' : '') .
            ($birthday_input_hover_css != "" ? 'input.p-nlform-birthday-input:hover{' . $birthday_input_hover_css . '}
' : '') .
            ($birthday_input_focus_css != "" ? 'input.p-nlform-birthday-input:focus{' . $birthday_input_focus_css . '}
' : '') .
            ($birthday_label_css != "" ? 'label.p-nlform-birthday-label{' . $birthday_label_css . '}
' : '') .
            ($gender_input_css != "" ? 'input.p-nlform-gender-input{' . $gender_input_css . '}
' : '') .
            ($gender_input_hover_css != "" ? 'input.p-nlform-gender-input:hover{' . $gender_input_hover_css . '}
' : '') .
            ($gender_input_focus_css != "" ? 'input.p-nlform-gender-input:focus{' . $gender_input_focus_css . '}
' : '') .
            ($gender_label_css != "" ? 'label.p-nlform-gender-label{' . $gender_label_css . '}
' : '') .
            ($language_input_css != "" ? 'input.p-nlform-language-input{' . $language_input_css . '}
' : '') .
            ($language_input_hover_css != "" ? 'input.p-nlform-language-input:hover{' . $language_input_hover_css . '}
' : '') .
            ($language_input_focus_css != "" ? 'input.p-nlform-language-input:focus{' . $language_input_focus_css . '}
' : '') .
            ($language_label_css != "" ? 'label.p-nlform-language-label{' . $language_label_css . '}
' : '') .
            ($custom1_input_css != "" ? 'input.p-nlform-custom1-input{' . $custom1_input_css . '}
' : '') .
            ($custom1_input_hover_css != "" ? 'input.p-nlform-custom1-input:hover{' . $custom1_input_hover_css . '}
' : '') .
            ($custom1_input_focus_css != "" ? 'input.p-nlform-custom1-input:focus{' . $custom1_input_focus_css . '}
' : '') .
            ($custom1_label_css != "" ? 'label.p-nlform-custom1-label{' . $custom1_label_css . '}
' : '') .
            ($custom2_input_css != "" ? 'input.p-nlform-custom2-input{' . $custom2_input_css . '}
' : '') .
            ($custom2_input_hover_css != "" ? 'input.p-nlform-custom2-input:hover{' . $custom2_input_hover_css . '}
' : '') .
            ($custom2_input_focus_css != "" ? 'input.p-nlform-custom2-input:focus{' . $custom2_input_focus_css . '}
' : '') .
            ($custom2_label_css != "" ? 'label.p-nlform-custom2-label{' . $custom2_label_css . '}
' : '') .
            ($custom3_input_css != "" ? 'input.p-nlform-custom3-input{' . $custom3_input_css . '}
' : '') .
            ($custom3_input_hover_css != "" ? 'input.p-nlform-custom3-input:hover{' . $custom3_input_hover_css . '}
' : '') .
            ($custom3_input_focus_css != "" ? 'input.p-nlform-custom3-input:focus{' . $custom3_input_focus_css . '}
' : '') .
            ($custom3_label_css != "" ? 'label.p-nlform-custom3-label{' . $custom3_label_css . '}
' : '') .
            ($lname_input_css != "" ? 'input.p-nlform-lname-input{' . $lname_input_css . '}
' : '') .
            ($lname_input_hover_css != "" ? 'input.p-nlform-lname-input:hover{' . $lname_input_hover_css . '}
' : '') .
            ($lname_input_focus_css != "" ? 'input.p-nlform-lname-input:focus{' . $lname_input_focus_css . '}
' : '') .
            ($lname_label_css != "" ? 'label.p-nlform-lname-label{' . $lname_label_css . '}
' : '') .
            ($email_input_css != "" ? 'input.p-nlform-email-input{' . $email_input_css . '}
' : '') .
            ($email_input_hover_css != "" ? 'input.p-nlform-email-input:hover{' . $email_input_hover_css . '}
' : '') .
            ($email_input_focus_css != "" ? 'input.p-nlform-email-input:focus{' . $email_input_focus_css . '}
' : '') .
            ($email_label_css != "" ? 'label.p-nlform-email-label{' . $email_label_css . '}
' : '') .
            ($btn_css != "" ? 'input.p-nlform-btn-input{' . $btn_css . '}
' : '') .
            ($btn_hover_css != "" ? 'input.p-nlform-btn-input:hover{' . $btn_hover_css . '}
' : '') .
            ($btn_focus_css != "" ? 'input.p-nlform-btn-input:focus{' . $btn_focus_css . '}
' : '') .
            ($fname_error_css != "" ? 'span.probance_msg_wrong_fname{' . $fname_error_css . '}
' : '') .
            ($lname_error_css != "" ? 'span.probance_msg_wrong_lname{' . $lname_error_css . '}
' : '') .
            ($gender_error_css != "" ? 'span.probance_msg_wrong_gender{' . $gender_error_css . '}
' : '') .
            ($language_error_css != "" ? 'span.probance_msg_wrong_language{' . $language_error_css . '}
' : '') .
            ($custom1_error_css != "" ? 'span.probance_msg_wrong_custom1{' . $custom1_error_css . '}
' : '') .
            ($custom2_error_css != "" ? 'span.probance_msg_wrong_custom2{' . $custom2_error_css . '}
' : '') .
            ($custom3_error_css != "" ? 'span.probance_msg_wrong_custom3{' . $custom3_error_css . '}
' : '') .
            ($birthday_error_css != "" ? 'span.probance_msg_wrong_birthday{' . $birthday_error_css . '}
' : '') .
            ($email_error_css != "" ? 'span.probance_msg_wrong_email, span.probance_msg_empty_email{' . $email_error_css . '}
' : '') .
            ($conf_message_css != "" ? 'p.probance_message_submit{' . $conf_message_css . '}
' : '');

        // css add to the .css file
        wp_add_inline_style('probance-newsletter-style', $css);
    }
}
