<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Pages;

class Meta
{

    public $name = "optin";
    public $plugin_name = "probance-optin";

    public function register()
    {
        add_action('wp_head', array($this, 'add_meta_version'));
    }

    // Fonction pour récupérer la version depuis l'entête
    public function probance_plugin_get_version() {
        if ( ! function_exists( 'get_plugin_data' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
        $plugin_data = get_plugin_data( ABSPATH . "wp-content/plugins/" . $this->plugin_name . "/" . $this->plugin_name . ".php" );
        return $plugin_data['Version'];
    }

    public function add_meta_version(){
        echo '<meta name="probance-plugin-version-' . esc_attr($this->name) . '" content="' . esc_attr($this->probance_plugin_get_version()) . '">' . "\n";
    }
}