<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Base;

use ProbanceOptin\Data\Translations;
use ProbanceOptin\Common\Utils;

class Enqueue
{

    public $popup_name = "probance_popup";
    const POPUP_NAME = "probance_popup";

    public function register()
    {

        add_action('admin_enqueue_scripts', array($this, 'admin_enqueues'));
        add_action('wp_enqueue_scripts', array($this, 'enqueues'));
    }

    /**
     * Admin enqueues scripts and style
     */
    public function admin_enqueues()
    {

        $currentPage = get_current_screen()->post_type;

        // Retrieve DEBUG option
        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            // write_log('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : '.$e);
            die('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
        }

        // Admin menu probance-popup
        if ($currentPage == self::POPUP_NAME) {
            wp_enqueue_style('probance-popup-style',  PLUGIN_OPTIN_URL . 'assets/probance_popup.css');
            wp_enqueue_style('probance-popup-admin-style',  PLUGIN_OPTIN_URL . 'assets/probance_popup_admin.css');
            // Admin menu other (optin)
        } else {
            wp_enqueue_script('probance-admin-form-handler', PLUGIN_OPTIN_URL . 'assets/admin.js', array(), '1.3.0', true);
            wp_enqueue_style('probance-newsletter-style',  PLUGIN_OPTIN_URL . 'assets/admin.css');
            wp_localize_script('probance-admin-form-handler', 'admin', array('debug' => $debug, 'ajaxurl' => admin_url('admin-ajax.php')));
        }
    }

    // Fonction pour récupérer la version depuis l'entête
    public function probance_optin_get_version() {
        if ( ! function_exists( 'get_plugin_data' ) ) {
            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
        }
        $plugin_data = get_plugin_data( ABSPATH . 'wp-content/plugins/probance-optin/probance-optin.php' );
        return $plugin_data['Version'];
    }

    /**
     * Frontend enqueues scripts and style
     */
    public function enqueues()
    {

        wp_enqueue_script('probance-plugin-optin',  PLUGIN_OPTIN_URL . 'assets/probance_plugin_optin.js');

        wp_localize_script('probance-plugin-optin', 'probance_plugin_optin', [
            'version' => $this->probance_optin_get_version()
        ]);

        $allTranslations = [];
        $langs = Utils::getLanguages();

        foreach ($langs as $lang) {
            $allTranslations[strtolower($lang)] = [];

            foreach (['newsletter', 'optin'] as $module) {
                $allTranslations[strtolower($lang)] = array_merge($allTranslations[strtolower($lang)], Translations::getTranslatedFields($module, $lang));
            }
        }

        if (!is_admin()) {


            // Popup section
            $popups = get_posts(array(
                'post_type' => self::POPUP_NAME,
                'posts_per_page' => -1,
            ));
            wp_enqueue_script('jquery');

            wp_enqueue_style('probance-popup-style',  PLUGIN_OPTIN_URL . 'assets/probance_popup.css');
            wp_enqueue_script('probance-popup-js',  PLUGIN_OPTIN_URL . 'assets/probance_popup.js');

            wp_localize_script('probance-popup-js', 'popupsList', array(
                'data' => $popups,
            ));

            // Récupérez le contenu CSS depuis le fichier unique
            $custom_css_content = get_option('custom_popup_styles');

            // Si aucun contenu n'est trouvé, utiliser un contenu CSS par défaut
            if (empty($custom_css_content)) {
                $custom_css_content = "\/* CSS generated automatically *\/";
            }

            // Écrire le contenu CSS dans un fichier CSS
            file_put_contents(PLUGIN_OPTIN_PATH . 'assets/popup_client_custom_style.css', $custom_css_content);

            // Enregistrer le fichier CSS
            wp_enqueue_style('probance-popup-client-custom-style',  PLUGIN_OPTIN_URL . 'assets/popup_client_custom_style.css');

            // Optin section
            wp_enqueue_script('probance-lang', PLUGIN_OPTIN_URL . 'assets/probance_lang.js', array('jquery'), '1.3.0', true);
            wp_enqueue_script('probance-newsletter', PLUGIN_OPTIN_URL . 'assets/probance_newsletter.js', array('jquery'), '1.8.2', true);
            // Enqueue style
            wp_enqueue_style('probance-newsletter-style',  PLUGIN_OPTIN_URL . 'assets/newsletter-form-css.css');
        }

        $recaptcha_checked = get_option('probance-optin_banner-cbrecaptcha');
        $recaptcha_sitekey = get_option('probance-optin_banner-recaptchasitekey');

        if ($recaptcha_checked == 1 && $recaptcha_sitekey != '') wp_enqueue_script('probance-newsletter-recaptcha', 'https://www.google.com/recaptcha/api.js?render=' . $recaptcha_sitekey, array(), '1.3.0', true);

        wp_script_add_data('probance-newsletter-recaptcha', 'async/defer', true);

        // Retrieve DEBUG option
        try {
            $debug = PROB_DEBUG;
        } catch (Exception $e) {
            // write_log('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : '.$e);
            die('[PROBANCE - optin] Erreur récupération "probance-optin_api-cbdebug" : ' . $e);
        }

        // Retrieve CBNAMES option
        try {
            $cbnames = get_option('probance-optin_banner-cbnames');
        } catch (Exception $e) {
            // write_log('[PROBANCE - optin] Erreur récupération "probance-optin_banner-cbnames" : '.$e);
            die('[PROBANCE - optin] Erreur récupération "probance-optin_banner-cbnames" : ' . $e);
        }

        wp_localize_script('probance-newsletter', 'probance_newsletter', array('debug' => $debug,  'cbnames' => $cbnames, 'rc_sitekey' => $recaptcha_sitekey, 'cb_recaptcha' => $recaptcha_checked, 'ajaxurl' => admin_url('admin-ajax.php')));
        wp_localize_script('probance-lang', 'probance_lang', array('debug' => $debug, 'translations' => $allTranslations));
    }
}
