<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin;

use ProbanceOptin\Common\Utils;

final class Init
{

    /**
     * Store all classes inside an array
     * @return array Full list of classes
     */
    public static function get_services()
    {
        return [
            Base\Enqueue::class,
            Base\Ajax::class,
            Pmail\Pmail::class,
            Pages\Admin::class,
            Pages\Newsletter::class,
            Pages\OptinConsents::class,
            Popup\Popup::class
        ];
    }

    /**
     * Loop througt the classes, initialize them,
     * and call the register method if it exists
     * @return
     */
    public static function register_services()
    {
        foreach (self::get_services() as $class) {

            Utils::write_log('[PROBANCE - INSTANCIATE] Try to instanciate : ' . $class);

            $service = self::instanciate($class);

            if (method_exists($service, 'register')) {
                $service->register();
            }
        }
    }

    /**
     * Initialize the class
     * @param   class $class       class from the services array
     * @return  class $instance    new instance of the class 
     */
    private static function instanciate($class)
    {
        $class_name =  explode('\\', $class)[2];


        if ($class instanceof $class_name) {
            Utils::write_log("[PROBANCE - INSTANCIATE]  An instance of $class_name has already been instantiated.");
        } else {
            Utils::write_log("[PROBANCE - INSTANCIATE]  A new instance of $class_name has been instantiated.");
            $service = new $class();
        }

        return $service;
    }
}
