<?php

/**
 * @package probance-optin
 */

namespace ProbanceOptin\Data;

use ProbanceOptin\Data\Data;
use ProbanceOptin\Data\Translations;

class ApiPmailFields extends Data
{
        public function __construct()
        {

                // Create data array
                $data = array(
                        array(
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-pmail-token',
                                'name'      => 'probance-optin_banner-pmail-token',
                                'properties-label' => 'PMAIL Token',
                                'size'      => '60',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => false,
                                'optional' => false
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-pmail-newaccount-cb',
                                'name'      => 'probance-optin_banner-pmail-newaccount-cb',
                                'size'      => '',
                                'properties-label' => 'N/A',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false,
                                'linked_to_other_field' => true
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-pmail-newaccount',
                                'name'      => 'probance-optin_banner-pmail-newaccount',
                                'properties-label' => 'New Account - campaign',
                                'size'      => '60',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false,
                                'activate' => 'probance-optin_banner-pmail-newaccount-cb'
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-1-cb',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-1-cb',
                                'size'      => '',
                                'properties-label' => 'N/A',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false,
                                'linked_to_other_field' => true
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-1',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-1',
                                'properties-label' => '01 - New Subscriber - campaign',
                                'size'      => '60',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false,
                                'activate' => 'probance-optin_banner-pmail-newsubscriber-1-cb'
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-2-cb',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-2-cb',
                                'size'      => '',
                                'properties-label' => 'N/A',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false,
                                'linked_to_other_field' => true
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-2',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-2',
                                'properties-label' => '02 - New Subscriber - campaign',
                                'size'      => '60',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false,
                                'activate' => 'probance-optin_banner-pmail-newsubscriber-2-cb'
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'checkbox',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-3-cb',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-3-cb',
                                'size'      => '',
                                'properties-label' => 'N/A',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => "0",
                                'to_translate' => false,
                                'linked_to_other_field' => true
                        ),
                        array(
                                'type'      => 'input',
                                'subtype'   => 'text',
                                'id'    => 'probance-optin_banner-pmail-newsubscriber-3',
                                'name'      => 'probance-optin_banner-pmail-newsubscriber-3',
                                'properties-label' => '03 - New Subscriber - campaign',
                                'size'      => '60',
                                'required' => '',
                                'value_type' => 'normal',
                                'wp_data' => 'option',
                                'default_value' => '',
                                'to_translate' => true,
                                'optional' => false,
                                'activate' => 'probance-optin_banner-pmail-newsubscriber-3-cb'
                        )
                );

                // Set default value using translations/_default.json file
                $data = Translations::setDefaultValues($data);

                parent::__construct($data);
        }

        public function getSectionInfo()
        {
                return array("id" => "probance-optin_section-pmail", "title" => "PMAIL - Campaigns");
        }
}
