jQuery(document).ready(function ($) {
    /**
     * Variables
     */
    var debug = probance_lang.debug;
    var translations = probance_lang.translations;

    /**
     * Execute
     */
    var currLang = getCurrentLanguauge();

    if (currLang == "") return;

    var trans = translations[currLang];

    if (trans == undefined || trans == null) return;

    if (debug == 1) console.log(`Current language : ${currLang}.`);
    if (debug == 1) console.log(`Translations : ${Object.values(translations)}.`);
    if (debug == 1) console.log(`Current Translations : ${Object.values(trans)}.`);

    // Modify label into newsletters
    var forms = jQuery("form[id^='probance_form_']");

    forms.each(function () {
        var dataId = $(this).data("probance-form-id");
        modifyNewsletterLabels(dataId);
    });

    // Modify optin label. Using sleep to handle label translation in checkout page.
    sleep(1000).then(() => {
        modifyOptinLabels();
    });

    // sleep time expects milliseconds
    function sleep(time) {
        return new Promise((resolve) => setTimeout(resolve, time));
    }

    /**
     * Funtion to modify optin labels from default to current language
     */
    function modifyOptinLabels() {
        var translations = trans;

        if (debug == 1) if (debug == 1) console.log(`Try to display : ${translations["probance-optin_webel-cblabel"]}`);

        if (debug == 1) if (debug == 1) console.log($("div#probance_optin_cb_wrapper span"));

        // Modification du text du span
        $("div#probance_optin_cb_wrapper span").html(translations["probance-optin_webel-cblabel"]);
    }

    /**
     * Funtion to modify newsletter labels from default to current language
     */
    function modifyNewsletterLabels(id_form) {
        var translations = trans;

        // ============== Titles
        mainTitle = jQuery(`form#probance_form_${id_form}`).parent().children(".p-nlform-maintitle");
        mainTitle.text(translations["probance-optin_banner-lbtitle"]);

        subTitle = jQuery(`form#probance_form_${id_form}`).parent().children(".p-nlform-subtitle");
        subTitle.text(translations["probance-optin_banner-lbsubtitle"]);

        // ============== Email
        emailLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-email-label`);
        if (/(.*)( \*)$/.test(emailLabelSelector.text().trim())) {
            newText = emailLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)$/, `${translations["probance-optin_banner-lbemail"]}$2`);
        } else {
            newText = translations["probance-optin_banner-lbemail"];
        }

        emailLabelSelector.text(newText);
        jQuery(`form#probance_form_${id_form} input#probance_newsletter_email_${id_form}`).attr(
            "placeholder",
            translations["probance-optin_banner-lbemail"].replace(/(.*)( \*)?$/, "$1")
        );

        emailMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_email`);
        emailMsgSelector.text(translations["probance-optin_banner-email-error-msg"]);

        // ============== First Name
        fnameLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-fname-label`);

        if (/(.*)( \*)$/.test(fnameLabelSelector.text().trim())) {
            newText = fnameLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)$/, `${translations["probance-optin_banner-lbfname"]}$2`);
        } else {
            newText = translations["probance-optin_banner-lbfname"];
        }
        fnameLabelSelector.text(newText);

        jQuery(`form#probance_form_${id_form} input#probance_newsletter_fname_${id_form}`).attr(
            "placeholder",
            translations["probance-optin_banner-lbfname"].replace(/(.*)( \*)?$/, "$1")
        );

        fnameMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_fname`);
        fnameMsgSelector.text(translations["probance-optin_banner-fname-error-msg"]);

        // ============== Last Name
        lnameLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-lname-label`);
        if (/(.*)( \*)$/.test(lnameLabelSelector.text().trim())) {
            newText = lnameLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)?$/, `${translations["probance-optin_banner-lblname"]}$2`);
        } else {
            newText = translations["probance-optin_banner-lblname"];
        }

        lnameLabelSelector.text(newText);

        jQuery(`form#probance_form_${id_form} input#probance_newsletter_lname_${id_form}`).attr(
            "placeholder",
            translations["probance-optin_banner-lblname"].replace(/(.*)( \*)?$/, "$1")
        );

        lnameMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_lname`);
        lnameMsgSelector.text(translations["probance-optin_banner-lname-error-msg"]);

        // ============== Birthday
        birthdayLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-birthday-label`);

        if (/(.*)( \*)$/.test(birthdayLabelSelector.text().trim())) {
            newText = birthdayLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)$/, `${translations["probance-optin_banner-birthday"]}$2`);
        } else {
            newText = translations["probance-optin_banner-birthday"];
        }

        birthdayLabelSelector.text(newText);

        birthdayMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_birthday`);
        birthdayMsgSelector.text(translations["probance-optin_banner-birthday-error-msg"]);

        // ============== Gender
        genderLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-gender-label`);

        if (/(.*)( \*)$/.test(genderLabelSelector.text().trim())) {
            if (debug == 1) console.log("Il y a une * dans : " + genderLabelSelector.text().trim());
            newText = genderLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)$/, `${translations["probance-optin_banner-gender"]}$2`);
        } else {
            if (debug == 1) console.log("Il n'y a pas une * dans : " + genderLabelSelector.text().trim());
            newText = translations["probance-optin_banner-gender"];
        }

        if (debug == 1) console.log("Remplacer par : " + newText);
        genderLabelSelector.text(newText);

        // Suppression des options
        selectGender = jQuery(`form#probance_form_${id_form} select#probance_newsletter_gender_${id_form}`);
        selectGender.empty();

        // Remplissage avec les nouvelles options
        optionsArray = translations["probance-optin_banner-gender-options-values"].split(";");

        // Ajouter chaque option au <select>
        jQuery.each(optionsArray, function (index, value) {
            selectGender.append('<option value="' + value + '">' + value + "</option>");
        });

        genderMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_gender`);
        genderMsgSelector.text(translations["probance-optin_banner-gender-error-msg"]);

        // ============== Languages
        languageLabelSelector = jQuery(`form#probance_form_${id_form} label.p-nlform-language-label`);

        if (/(.*)( \*)$/.test(languageLabelSelector.text().trim())) {
            newText = languageLabelSelector
                .text()
                .trim()
                .replace(/(.*)( \*)$/, `${translations["probance-optin_banner-language"]}$2`);
        } else {
            newText = translations["probance-optin_banner-language"];
        }

        languageLabelSelector.text(newText);

        languageMsgSelector = jQuery(`form#probance_form_${id_form} span.probance_msg_wrong_language`);
        languageMsgSelector.text(translations["probance-optin_banner-language-error-msg"]);

        // ============== Button check ici!!!!
        btns = jQuery(`form#probance_form_${id_form} input#probance_newsletter_submit_btn_${id_form}`).val(
            translations["probance-optin_banner-lbbtn"]
        );

        // ============== Conf Message
        jQuery(`form#probance_form_${id_form} div.probance_message_submit p.message`).text(
            translations["probance-optin_banner-conf-message"]
        );
        jQuery(`form#probance_form_${id_form} div.probance_message_submit_faillure p.message`).text(
            translations["probance-optin_banner-conf-error-message"]
        );
    }

    /**
     * Function to retrieve cookie by name
     * @param {string} cname
     * @returns
     */
    function getCookie(cname) {
        let name = cname + "=";
        let decodedCookie = decodeURIComponent(document.cookie);
        let ca = decodedCookie.split(";");

        for (let i = 0; i < ca.length; i++) {
            let c = ca[i];
            while (c.charAt(0) == " ") {
                c = c.substring(1);
            }
            if (c.indexOf(name) == 0) {
                return c.substring(name.length, c.length);
            }
        }

        return "";
    }

    /**
     * Function to get the current language.
     * 1 - Using Cookie
     * 2 - Using <html> class WPML
     * 3 - Using <html> lang attribute
     * 4 - Using <body> data attribute
     *
     */
    function getCurrentLanguauge() {
        // Try to retrieve lang using WPML cookie
        if (debug == 1) console.log("Trying to get WPML current language using WPML Cookie.");

        var cname = "wp-wpml_current_language";
        var lang = getCookie(cname);

        if (lang != "") {
            if (debug == 1) console.log(`Language from WPML Cookie : ${lang}`);
            return lang;
        }

        // Try to retrieve lang using <html> class WPML
        if (debug == 1) console.log("Trying to get current language using <html> class WPML.");

        var langs = jQuery("body")[0].attributes.class.nodeValue.match("wpml-([a-z]{2})");

        if (langs != null) {
            lang = langs[1];

            if (lang != undefined && lang != "") {
                return lang;
            }
        }

        // Try to retrieve lang using <html> lang attribute
        if (debug == 1) console.log("Trying to get current language using <html> lang attribute.");

        var lang = jQuery("html")[0].lang.split("-")[0];

        if (lang != undefined && lang != "") {
            return lang;
        }

        // Try to retrieve lang using <html> lang attribute
        if (debug == 1) console.log("Trying to get current language using <body> data attribute.");

        var lang = jQuery("body")[0].attributes.data.nodeValue;

        if (lang != undefined && lang != "") {
            return lang;
        }

        return "";
    }
});
